#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'script',
  when => 'after',
  time_estimate => "1-2 секунды",
  comment => "Чинит настройки конкретного пользователя. Перезапускать не стоит (в случае необходимости - спросить n-boy@)"
}
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use User;


$log->out('START');

my $uid = 173127053;

my $uid_options = get_one_field_sql(PPC(uid => $uid), 'select options from users_options where uid = ?', $uid);
$log->out("Old options:\n$uid_options");

$uid_options =~ s/^([\w\W]+)\s*\- columns:[\w\W]+?$/$1\n/; # обрезаю последний отчет МОЛ из настроек, и добавляю "\n" для корректности yaml-а
my $new_options = User::parse_user_options($uid_options);
$new_options = {statistic_with_nds => 1, # из настроек пользователя на devtest
                %$new_options};
User::set_user_options($uid, $new_options);

my $saved_new_options = get_one_field_sql(PPC(uid => $uid), 'select options from users_options where uid = ?', $uid);
$log->out("Saved new options:\n$saved_new_options");

$log->out('FINISH');
