#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '10 секунд',
  comment => 'Снимаем галочку про тизер с клиентов тех агентств, у которых нет графика НДС (не платили ещё ни разу, например)',
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;
use ShardingTools;
use Client;

$log->out('START');

foreach_shard shard => [ppc_shards()], sub {
    my ($shard) = @_;

    $log->msg_prefix("[shard_$shard]");
    $log->out('Fetching possible clients');

    my $possible_clients = get_all_sql(PPC_HEAVY(shard => $shard), '
        SELECT t.ClientID, c.AgencyID
        FROM clients_to_force_multicurrency_teaser t
        LEFT JOIN currency_convert_queue q ON q.ClientID = t.ClientID
        INNER JOIN users u ON u.ClientID = t.ClientID
        INNER JOIN campaigns c ON c.uid = u.uid AND c.AgencyID > 0 AND c.statusEmpty = "No"
        -- Агентство может жить и в другом шарде, но на всякий случай проверяем в текущем, чтобы снизить общее число запросов
        LEFT JOIN client_nds ands ON ands.ClientID = c.AgencyID
        WHERE
            q.ClientID IS NULL
            AND ands.ClientID IS NULL
        GROUP BY t.ClientID, c.AgencyID
        ORDER BY NULL
    ');
    $log->out('Got ' . scalar(@$possible_clients) . ' possible clients to check for agency NDS');

    my %agid2clids;
    for my $row (@$possible_clients) {
        push @{ $agid2clids{ $row->{AgencyID} } }, $row->{ClientID};
    }

    my @agency_ids = keys %agid2clids;
    $log->out('Fetching NDS for ' . scalar(@agency_ids) . ' agencies');
    my $agency_ndses = mass_get_client_NDS(\@agency_ids);

    my @remove_teaser_clientids;
    while ( my($agency_id, $client_ids) = each %agid2clids ) {
        my $agency_nds = $agency_ndses->{$agency_id};
        if (!defined $agency_nds) {
            my $client_ids = $agid2clids{$agency_id};
            $log->out("No NDS known for AgencyID $agency_id, will remove teaser for ClientIDs:", $client_ids);
            push @remove_teaser_clientids, @$client_ids;
        }
    }

    if (@remove_teaser_clientids) {
        $log->out('Removing teaser for ' . scalar(@remove_teaser_clientids) . ' clients:', \@remove_teaser_clientids);
        do_delete_from_table(PPC(shard => $shard), 'clients_to_force_multicurrency_teaser', where => {ClientID => \@remove_teaser_clientids});
    }

    $log->msg_prefix('');
};

$log->out('FINISH');
