#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "несколько секунд",
}

=cut

use warnings;
use strict;
use utf8;

use FindBin qw/$Bin $Script/;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::ListUtils;

use Settings;
use ScriptHelper;

use ShardingTools;


my (%bids, %pids);

$log->out('START');

# Загружаем данные из файлов
_load_data_to_hash('banners', \%bids);
_load_data_to_hash('phrases', \%pids);
_load_data_to_hash('sitelinks', \%bids);
$log->out({ bids_for_remoderate => [nsort keys %bids],
            pids_for_remoderate => [nsort keys %pids],
          });

$log->out('process banners');
foreach_shard bid => [keys %bids], with_undef_shard => 1, sub {
    my ($shard, $ids_chunk) = @_;
    if ($shard) {
        $log->msg_prefix("[shard_$shard]");
        my $data = get_hashes_hash_sql(PPC(shard => $shard), [
                                            'SELECT bid, statusModerate
                                                  , vcard_id, phoneflag
                                                  , sitelinks_set_id, statusSitelinksModerate
                                               FROM banners',
                                              WHERE => {bid => $ids_chunk}
                                        ]);
        $log->out({banners_data => $data});
        $log->out('fix banner statusModerate');
        my $res = do_update_table(PPC(shard => $shard),
                                  'banners',
                                  {
                                        statusModerate => 'Ready',
                                        phoneflag => 'IF(vcard_id IS NOT NULL, "Ready", phoneflag)',
                                        statusSitelinksModerate => 'IF(sitelinks_set_id IS NOT NULL, "Ready", statusSitelinksModerate)',
                                  },
                                  where => {
                                        bid => $ids_chunk,
                                        statusModerate__ne => 'New',
                                  },
                                  dont_quote => [
                                        'phoneflag',
                                        'statusSitelinksModerate',
                                  ]);
        $log->out("banners updated, affected $res rows");
    } else {
        $log->msg_prefix(undef);
        $log->out({ERROR_bids_without_shard => $ids_chunk});
    }
};

$log->out('process phrases');
foreach_shard pid => [keys %pids], with_undef_shard => 1, sub {
    my ($shard, $ids_chunk) = @_;
    if ($shard) {
        $log->msg_prefix("[shard_$shard]");
        my $data = get_hashes_hash_sql(PPC(shard => $shard), [
                                            'SELECT pid, statusModerate FROM phrases',
                                            WHERE => {pid => $ids_chunk}
                                        ]);
        $log->out({phrases_data => $data});
        $log->out('fix phrases statusModerate');
        my $res = do_update_table(PPC(shard => $shard),
                                  'phrases',
                                  {
                                        statusModerate => 'Ready',
                                  },
                                  where => {
                                        pid => $ids_chunk,
                                        statusModerate__ne => 'New',
                                  });
        $log->out("phrases updated, affected $res rows");
    } else {
        $log->msg_prefix(undef);
        $log->out({ERROR_pids_without_shard => $ids_chunk});
    }
};
$log->msg_prefix(undef);


$log->out('FINISH');
exit(0);

sub _get_data_path {
    return sprintf('%s/%s.%s.data', $Bin, ($Script =~ s/.pl$//r), shift);
}

sub _load_data_to_hash
 {
    my ($type, $hash_ref) = @_;

    $log->out("read $type data");
    my $fn = _get_data_path($type);
    open(my $fh, '<', $fn) or $log->die("Error opening $fn: $!");
    while (my $line = <$fh>) {
        next unless $line =~ m/^(\d+)\s+/;
        $hash_ref->{$1} = undef;
    }
    close($fh);
}


