#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5-10 секунд",
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard]");
    $log->out('fetch broken campaigns data');
    my $camps_data = get_hashes_hash_sql(PPC(shard => $shard),
                                         'SELECT cid
                                               , OrderID
                                               , archived
                                               , statusBsSynced
                                               , autobudget_avg_cpa
                                               , autobudget_goal_id
                                            FROM campaigns
                                           WHERE autobudget_avg_cpa > 0
                                                 AND autobudget_goal_id IS NULL'
                                        );
    $log->out({camps_data => $camps_data});
    next unless %$camps_data;

    $log->out('fix autobudget_goal_id in campaigns');
    my $res = do_update_table(PPC(shard => $shard),
                              'campaigns',
                              {
                                    autobudget_goal_id => 0,
                                    statusBsSynced => 'No',
                              },
                              where => {
                                    cid__int => [keys %$camps_data],
                                    autobudget_avg_cpa__int__gt => 0,
                                    autobudget_goal_id__is_null => 1,
                              },
                              );
    $log->out("Updated campaigns, affected $res rows");

    $log->msg_prefix(undef);
}

$log->out('FINISH');

