#!/usr/bin/perl

use my_inc "..";


=head1 DEPLOY

# approved by hrustyashko
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => "20 часов",
    comment => q/
      Если в логе будут сообщения "Campaign #ххх has been changed", надо запустить повторно.
      Если таких сообщений много - сделать --chunk-size поменьше.

      Возможные параметры

      --сid n       - конкретная кампания
      --cids n-m    - диапазон
      --сids n-     - начать с кампании
      --chunk-size  - размер пачки, по умолчанию 100000
      --sleep-coef
    /,
}

=cut


=head1 DESCRIPTION

Конвертирует все лёгкие кампании в "распределённый недельный бюджет"

Опиционалые параметры:
    --cid - кампании для обработки, можно диапазоны. по умолчанию - все
    --dry-run

=cut 

use 5.010;
use strict;
use warnings;
use utf8;

use Settings;
use ScriptHelper;

use Yandex::DBTools;
use Yandex::DBShards;
use ShardingTools;
use List::Util qw/ min max /;
use Yandex::HashUtils;
use YAML;
use JSON;

use Common;
use Campaign;
use Currencies;
use Forecast::Autobudget;
use Yandex::ExecuteJS;


my $CHUNK_SIZE = 100000;
my $SLEEP_COEF = 1;

my $NUM_DAYS_IN_WEEK = 6;


my $cid_str;
GetOptions( 
    'cid|cids=s' => \$cid_str, 
    "sleep-coef=f" => \$SLEEP_COEF,
    "chunk-size=i" => \$CHUNK_SIZE,
    "dry-run" => \my $DRY_RUN,
    );

my $cid_start = 0;
my $cid_end = max @{ get_one_column_sql(PPC(shard=>'all'), 'select max(cid) from campaigns') };
if ( $cid_str && (my ($from, $is_range, $to) = $cid_str =~ / ^ (\d+) (?: (- | \.\.) (\d+)? )? /xms) ) {
    $cid_start = $from;
    $cid_end   = $is_range ? $to || $cid_end : $from;
}

$log->out("START for cids $cid_start-$cid_end");

my $i_cid = $cid_start;
while ($i_cid <= $cid_end) {
    my $st = time;

    my $csize = min ($CHUNK_SIZE, $cid_end-$i_cid+1);
    my $j_cid = $i_cid + $csize - 1;
    $log->out("checking cids #$i_cid .. #$j_cid");

    for my $shard (ppc_shards()) {
        my $camps =
            get_all_sql( PPC(shard => $shard), [
                'SELECT cid, uid,
                    c.autobudget_sum,
                    co.manual_autobudget_sum,
                    co.budget_strategy,
                    co.positions_strategy,
                    c.autobudget_limit_clicks,
                    IFNULL(c.currency, "YND_FIXED") AS currency,
                    c.autobudget_avg_bid,
                    sco.options,
                    c.LastChange,
                    uo.statusEasy
                FROM campaigns c
                JOIN camp_options co USING(cid)
                JOIN users_options uo USING(uid)
                LEFT JOIN camp_secondary_options sco using(cid)',
                WHERE => {
                    statusEasy => 'Yes',
                    budget_strategy__ne => 'distributed',
#                    budget_strategy__not_in => [ qw/easy_week_bundle distributed fast/ ],
                    cid__between => [$i_cid, $j_cid],
                },
            ]);
        if (@$camps) {
            for my $camp (@$camps) {
                $camp->{options} = YAML::Load($camp->{options} || "--- {}\n");

                state $recalc_sub = {
                    fast => sub { $_[0]->{autobudget_sum} },
                    easy_week_bundle => sub {
                        my ($camp) = @_;
                        my $o = $camp->{options};
                        my $sum = $o->{easy_week_bundle_sum_ue} || $o->{easy_week_bundle_sum};
                        return 0  if !$sum;
                        my $days = $o->{easy_week_bundle_period} || _get_forecast_days($camp);
                        return sprintf( "%d", $sum / ($days || $NUM_DAYS_IN_WEEK) * $NUM_DAYS_IN_WEEK );
                    },
                };

                my $recalc = $recalc_sub->{$camp->{budget_strategy}};
                my $autobudget_sum = min (
                    max(
                        $recalc->($camp),
                        get_currency_constant($camp->{currency}, 'MIN_AUTOBUDGET'),
                    ),
                    get_currency_constant($camp->{currency}, 'MAX_AUTOBUDGET'),
                );

                my $update_values = {
                    autobudget => 1,
                    budget_strategy => 'distributed',
                    autobudget_sum => $autobudget_sum,
                    manual_autobudget_sum => $autobudget_sum,
                    i_know_strategy_min_price => 1,
                };

                if ($DRY_RUN) {
                    say Dump [ $camp, $update_values ];
                }
                else {
                    my $is_campaign_intact = get_one_field_sql(PPC(shard => $shard), [
                            'SELECT cid
                            FROM campaigns c
                            JOIN camp_options co USING(cid)
                            JOIN users_options uo USING(uid)',
                            WHERE => {
                                cid => $camp->{cid},
                                'c.LastChange' => $camp->{LastChange},
                                'co.budget_strategy' => $camp->{budget_strategy},
                                'uo.statusEasy' => $camp->{statusEasy},
                            },
                            LIMIT => 1,
                        ]);
                    if (!$is_campaign_intact) {
                        $log->out("Campaign #$camp->{cid} has been changed; skipping");
                        next;
                    }

                    $log->out(to_json(hash_cut $camp, qw/ cid budget_strategy autobudget_sum currency options/));
                    $log->out("Going to change cid #$camp->{cid}: autobudget_sum = $autobudget_sum");

                    my $err;
                    eval {
                        $err = Common::update_camp_autobudget($camp->{uid}, $camp->{cid}, undef, $update_values, {});
                    };

                    $err ||= $@;
                    if (!$err) {
                        $log->out("Succeed cid #$camp->{cid}");
                    } else {
                        $log->out("Failed cid #$camp->{cid}: $@");
                    }
                }
            }
        }
    }

    $i_cid += $csize;

    if (my $pause = $SLEEP_COEF * (time - $st)) {
        $log->out(sprintf "sleep %f", $pause);
        sleep $pause;
    }
}

$log->out('FINISH');

exit;


sub _get_forecast_days {

    return $NUM_DAYS_IN_WEEK;
}
