#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv, mirage
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5-15 минут (за счет пауз между обновлениями, без них - около минуты)",
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry;

use Settings;
use ScriptHelper;

use ShardingTools;

my %TYPE2ID = (
    'banner' => 'bid',
    'phrases' => 'pid',
    'contactinfo' => 'bid',
    'sitelinks_set' => 'bid',
    'image' => 'bid',
);

$log->out('START');
my %BID2CID;
for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard]");
    $log->out('fetch data from mod_object_version');
    my $data = get_all_sql(PPC(shard => $shard), [
                           'SELECT v.obj_id
                                 , v.obj_type
                                 , v.cid
                                 , v.export_version
                                 , v.update_time
                                 , c.archived
                              FROM mod_object_version v
                                   JOIN campaigns c ON c.cid = v.cid',
                             WHERE => {
                                    update_time__between => [ '2015-02-05 17:00:00', '2015-02-05 20:00:00' ],
                             },
                           ]);
    $log->out({mod_object_version => $data});
    my (%BIDS, %PIDS, %IMAGE_BIDS, %camps);
    for my $row (@$data) {
        if ($row->{archived} eq 'Yes') {
            $log->out({skip_row => 'campaign archived',
                      obj_id => $row->{obj_id},
                      obj_type => $row->{obj_type},
                      cid => $row->{cid},
                      });
            next;
        }
        if (!$row->{ obj_type } || !exists $TYPE2ID{ $row->{obj_type} }) {
            $log->out({WARN => 'unknown type', row => $row});
        } elsif ($TYPE2ID{ $row->{obj_type} } eq 'bid') {
            $BIDS{ $row->{obj_id} } = undef;
            $BID2CID{ $row->{obj_id} } = $row->{cid};
        } elsif ($TYPE2ID{ $row->{obj_type} } eq 'pid') {
            $PIDS{ $row->{obj_id} } = undef;
        } elsif ($TYPE2ID{ $row->{obj_type} } eq 'image_bid') {
            $IMAGE_BIDS{ $row->{obj_id} } = undef;
        }
    }
    $log->out(sprintf("got %d bids, %d pids, %d images", scalar(keys %BIDS), scalar(keys %PIDS), scalar(%IMAGE_BIDS)));
    my ($pids_cnt, $bids_cnt) = (0, 0);
    for my $pids_chunk (chunks([keys %PIDS], 5_000)) {
        $log->out('fetch phrases data chunk');
        my $phrases_data = get_hashes_hash_sql(PPC(shard => $shard), [
                                               'SELECT pid
                                                     , statusModerate
                                                  FROM phrases',
                                                 WHERE => {
                                                        pid => $pids_chunk,
                                                 },
                                               ]);
        $log->out({phrases => $phrases_data});
        my @ids_to_update = grep {
                exists $phrases_data->{$_}
                && $phrases_data->{$_}->{statusModerate} !~ m/^(?:New|Yes|No)$/
            } @$pids_chunk;
        $pids_cnt += scalar(@ids_to_update);
        $log->out({pids_to_update => \@ids_to_update, skip_pids => xminus($pids_chunk, \@ids_to_update)});
        relaxed times => 20, sub {
            my $res = do_update_table(PPC(shard => $shard), 'phrases',
                                      {
                                            statusModerate => 'Ready',
                                            LastChange => 'LastChange',
                                      },
                                      where => {
                                            pid => \@ids_to_update,
                                            statusModerate__not_in => ['Yes', 'No', 'New'],
                                      },
                                      dont_quote => [
                                            'LastChange'
                                      ],
                                      );
            $log->out("phrases updated, affected $res rows");
        };
    }
    for my $bids_chunk (chunks([keys %BIDS], 2_500)) {
        $log->out('fetch banners data chunk');
        my $banners_data = get_hashes_hash_sql(PPC(shard => $shard), [
                                               'SELECT b.bid
                                                     , b.statusModerate AS b_statusModerate
                                                     , b.vcard_id
                                                     , b.phoneflag
                                                     , b.sitelinks_set_id
                                                     , b.statusSitelinksModerate
                                                     , bim.image_id
                                                     , bim.statusModerate AS i_statusModerate
                                                  FROM banners b
                                                       LEFT JOIN banner_images bim ON bim.bid = b.bid',
                                                 WHERE => {
                                                        'b.bid' => $bids_chunk,
                                                 },
                                               ]);
        $log->out({banners => $banners_data});
        my @ids_to_update = grep {
                exists $banners_data->{$_}
                && ($banners_data->{$_}->{b_statusModerate} !~ m/^(?:Yes|No)$/
                    || $banners_data->{$_}->{vcard_id} && $banners_data->{$_}->{phoneflag} !~ m/^(?:Yes|No|Sent|)$/
                    || $banners_data->{$_}->{vcard_id} && $banners_data->{$_}->{phoneflag} eq 'Sent' && $banners_data->{$_}->{b_statusModerate} ne 'No'
                    || $banners_data->{$_}->{sitelinks_set_id} && $banners_data->{$_}->{statusSitelinksModerate} !~ m/^(?:Yes|No)$/
                    || $banners_data->{$_}->{image_id} && $banners_data->{$_}->{i_statusModerate} !~ m/^(?:Yes|No)$/
                   ) && $banners_data->{$_}->{b_statusModerate} ne 'New'
            } @$bids_chunk;
        $bids_cnt += scalar(@ids_to_update);
        $log->out({bids_to_update => \@ids_to_update, skip_bids => xminus($bids_chunk, \@ids_to_update)});
        relaxed times => 20, sub {
            my $res = do_sql(PPC(shard => $shard), [
                 q/UPDATE banners b
                          LEFT JOIN banner_images bim ON bim.bid = b.bid
                      SET b.statusModerate = IF(b.statusModerate NOT IN ('Yes', 'No'), 'Ready', b.statusModerate)
                        , b.LastChange = b.LastChange
                        , b.phoneflag = IF(b.vcard_id IS NOT NULL AND (b.phoneflag NOT IN ('Yes', 'No', 'Sent', '') OR b.phoneflag = 'Sent' AND b.statusModerate != 'No'), 'Ready', b.phoneflag)
                        , b.statusSitelinksModerate = IF(b.sitelinks_set_id IS NOT NULL AND b.statusSitelinksModerate NOT IN ('Yes', 'No'), 'Ready', b.statusSitelinksModerate)
                        , bim.statusModerate = IF(bim.image_id IS NOT NULL AND bim.statusModerate NOT IN ('Yes', 'No'), 'Ready', bim.statusModerate)
                        , bim.date_added = bim.date_added
                        /,
                    WHERE => {
                            'b.bid' => \@ids_to_update,
                            'b.statusModerate__ne' => 'New',
                    }
                 ]);
            $log->out("banners updated, affected $res rows");
        };
        # считаем статистику по кампаниям
        $camps{ $BID2CID{$_} } = undef for @ids_to_update;
    }
    $log->out(sprintf("total possible updated: %d bids, %d pids, %d camps", $bids_cnt, $pids_cnt, scalar(keys %camps)));
}
$log->msg_prefix(undef);

$log->out('FINISH');

