#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка 30 минут с дефолтным --sleep-coef 0.1',
  comment => 'Исправляем пустую строку в phoneflag на Sent'
}

=cut

use constant SELECT_CHUNK_SIZE => 1_000;

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

my $SLEEP_COEF = 0.1;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard$shard]");
    my $bids;
    do {
        relaxed times => $SLEEP_COEF, sub {
            $log->out('Fetching banners chunk to fix');
            $bids = get_one_column_sql(PPC_HEAVY(shard => $shard), 'SELECT bid FROM banners WHERE phoneflag = "" LIMIT ?', SELECT_CHUNK_SIZE);
            my $bids_cnt = scalar @$bids;
            $log->out("Got $bids_cnt banners to fix");
            if ($bids_cnt) {
                $log->out("Fixing bids:", $bids);
                my $updated_rows = do_update_table(PPC(shard => $shard), 'banners', {phoneflag => 'Sent'}, where => {phoneflag => '', bid => $bids});
                $log->out("Successfully fixed $updated_rows banners");
            }
        };
    } while @$bids > 0;
}
$log->msg_prefix('');

$log->out('FINISH');
