#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка 40 минут при умолчальном --sleep-coef',
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry;

use Settings;
use ScriptHelper;

use ShardingTools;

my $SLEEP_COEF = 1;
extract_script_params(
    'sleep-coef=i' => \$SLEEP_COEF,
);

my $sql_part = q@
     FROM mod_object_version mov
     LEFT JOIN banners b on b.bid = mov.obj_id AND mov.obj_type IN ('banner','contactinfo','sitelinks_set','image')
     LEFT JOIN banner_images bim ON bim.bid = b.bid AND mov.obj_type = 'image' AND bim.statusShow = 'Yes'
     LEFT JOIN phrases p on p.pid = mov.obj_id AND mov.obj_type = 'phrases'
     WHERE (
           (mov.obj_type IN ('banner','contactinfo','sitelinks_set','image') AND b.bid IS NULL)
        OR (mov.obj_type = 'banner' AND b.statusModerate NOT IN ('Sending', 'Sent'))
        OR (mov.obj_type = 'contactinfo' AND (IFNULL(b.vcard_id, 0) = 0 OR b.phoneflag NOT IN ('Sending', 'Sent')))
        OR (mov.obj_type = 'sitelinks_set' AND (IFNULL(b.sitelinks_set_id, 0) = 0 OR b.statusSitelinksModerate NOT IN ('Sending', 'Sent')))
        OR (mov.obj_type = 'image' AND (bim.bid IS NULL OR bim.statusModerate NOT IN ('Sending', 'Sent')))
        OR (mov.obj_type = 'phrases' AND (p.pid IS NULL OR p.statusModerate NOT IN ('Sending', 'Sent')))
     )
@;

$log->out('START');
for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard $shard]");

    $log->out('fetch data from mod_object_version');
    my $data_to_delete = get_all_sql(PPC_HEAVY(shard => $shard), [
                           "SELECT mov.obj_id
                                 , mov.obj_type
                                 , mov.cid
                                 , mov.export_version
                                 , mov.update_time
                              $sql_part
                           "]);
    $log->out('Will delete ' . scalar(@$data_to_delete) . ' rows:');
    my %type2ids;
    for my $row (@$data_to_delete) {
        $log->out($row);
        push @{$type2ids{$row->{obj_type}}}, $row->{obj_id};
    }
    undef $data_to_delete;

    while (my ($type, $ids) = each %type2ids) {
        for my $ids_chunk (chunks [nsort @$ids], 1_000) {
            $log->out("Removing versions for chunk of rows with ids of type $type:", join(',', @$ids_chunk));
            relaxed times => $SLEEP_COEF, sub {
                my $deleted_rows_cnt = do_sql(PPC(shard => $shard), ["DELETE mov $sql_part AND", {obj_type => $type, obj_id => $ids_chunk}]);
                $log->out("Deleted $deleted_rows_cnt");
            };
        }
    }
}
$log->msg_prefix(undef);

$log->out('FINISH');

