#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
    type => 'script',
    when => 'after',
    time_estimate => '10 min',
    comment => "
        Исправляем битые телефоны в визитках.
        можно запускать с коэффициентом для вычисления паузы между апдейтами (что бы реплики не отставали)
        по умолчанию: 0.1

        ./deploy/20150303_fix_broken_vcard_phone.pl --sleep-coeff=1
    "
}

=cut

use my_inc '..';

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

# --------------------------------------------------------------------
sub main {
    $log->out('START');

    my $SLEEP_COEF = 0.1;
    extract_script_params(
        'sleep-coef' => \$SLEEP_COEF,
    );

    for my $shard (ppc_shards()) {
        $log->msg_prefix("[shard$shard]");

        $log->out('Fetching banners chunk to fix');
        do_sql(PPC_HEAVY(shard => $shard), "SET SESSION group_concat_max_len = 1000000");
        my $phones = get_all_sql(PPC_HEAVY(shard => $shard),
                                 'select vcards.vcard_id, vcards.phone, vcards.LastChange, group_concat(banners.bid) as bids
                                  from vcards
                                    join banners using(vcard_id)
                                  where vcards.phone like "##%"
                                  group by vcard_id
                                 '
                                );

        if (@$phones) {
            $log->out({"Fixing phones" => $phones});

            for my $row (@$phones) {
                my $fixed_phone = $row->{phone};
                $fixed_phone =~ s/^##//;
                $fixed_phone =~ s/##$/#/;

                relaxed times => $SLEEP_COEF, sub {
                    my $updated_rows = do_update_table(PPC(shard => $shard),
                                                       'vcards',
                                                       {phone => $fixed_phone, LastChange__dont_quote => 'NOW()'},
                                                       where => {vcard_id => $row->{vcard_id}, phone => $row->{phone}}
                                                      );
                    $log->out({"updated_vcards" => $updated_rows, vcard_id => $row->{vcard_id}, old_phone => $row->{phone}, new_phone => $fixed_phone});

                    # перепосылаем в БК
                    $updated_rows = do_update_table(PPC(shard => $shard),
                                                       'banners',
                                                       {statusBsSynced => "No"},
                                                       where => {bid => [split /,/, $row->{bids}]}
                                                      );
                    $log->out({"updated_banners" => $updated_rows, bids => $row->{bids}});
                };
            }
        }
    }

    $log->msg_prefix('');

    $log->out('FINISH');
}

# --------------------------------------------------------------------
main();
