#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "monitor",
    when => 'after',
    time_estimate => "1 sec",
    sql => "RENAME TABLE log_strategy_change TO log_strategy_change_to_delete"
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "1 час",
    comment => "если понадобится перезапустить, нужно указать последнюю обработанную дату из лога"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBSchema;
use Yandex::TimeCommon;
use Yandex::Retry;

use Settings;
use ScriptHelper;

my $START_DATE;
my $FIELDS_SQL = "uid, cid, data_json, ip, logtime, new_strategy_name, old_strategy_name";
my $MONITOR_TABLE = 'log_strategy_change_to_delete';
extract_script_params(
    'start-date=s' => \$START_DATE,
    );

$log->out('START');

$START_DATE //= get_one_field_sql(MONITOR, "SELECT date(min(logtime)) FROM $MONITOR_TABLE");
for my $date (get_distinct_dates($START_DATE, today())) {
    $log->out("start select data for $date");
    
    my $log_table = "log_strategy_change_".substr($date, 0, 6);
    create_table_by_schema(PPCLOG, $log_table, like => "ppclog.log_strategy_change_YYYYMM", if_not_exists => 1);

    my $cnt = 0;
    relaxed times => 2, sub {
        my $sth = exec_sql(MONITOR, "SELECT $FIELDS_SQL FROM $MONITOR_TABLE
                                            WHERE logtime between '$date' and '${date}235959'");
        while(my $chunk = $sth->fetchall_arrayref([], 1_000)) {
            $cnt += do_mass_insert_sql(PPCLOG, "INSERT INTO $log_table ($FIELDS_SQL) VALUES %s", $chunk);
        }
    };
    $log->out("Inserted $cnt rows");
}

$log->out('FINISH');

