#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
[
{
  type => 'sql',
  webstop => "1",
  db => "ppc:all",
  when => 'before',
  time_estimate => "по 5 мин на каждый шард",
  sql => [
    q/ ALTER TABLE camp_options ADD COLUMN `is_related_keywords_enabled` tinyint(1) unsigned NOT NULL DEFAULT "0" /,
  ],
},
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка 10 минут',
  comment => q/
    Проставляем всем кампаниям дефолтное значение is_related_keywords_enabled.
    (лёгкие - 0, профи - 1)

    Теоретически возможны гонки из-за копирования кампаний; проверить результат можно

    select cid from camp_options join campaigns using(cid) join users_options using(uid)
    where statuseasy="No" and is_related_keywords_enabled=0;

    Если выдаст какие-то cid-ы, перезапустить деплой. Можно с [мульти]параметром --cid
  /,
}
]

=cut

use warnings;
use strict;
use utf8;
use my_inc '..';

# код переехал в protected/one-shot/set_related_keywords_flag.pl

exit;
