#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppc:all",
    when => 'before',
    time_estimate => "2 секунды",
    sql => [
        "CREATE TABLE mod_files (
        ClientID int(10) unsigned NOT NULL, 
        file_id int(10) unsigned NOT NULL, 
        filename varchar(100) DEFAULT NULL, 
        uploaded_at timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP, 
        is_moderated tinyint(1) unsigned NOT NULL DEFAULT '0', 
        PRIMARY KEY (ClientID,file_id));",
        
        "CREATE TABLE mod_documents (
        doc_id int(10) unsigned NOT NULL, 
        ClientID int(10) unsigned NOT NULL, 
        domain_id int(10) unsigned NOT NULL, 
        statusModerate enum('Yes','Not_enough','No') NOT NULL, 
        statusBsSynced enum('No','Yes','Sending') NOT NULL DEFAULT 'No', 
        expires TIMESTAMP NULL, 
        PRIMARY KEY (doc_id), 
        KEY ClientID_domain_id (ClientID,domain_id), 
        KEY statusBsSynced (statusBsSynced), 
        KEY expires (expires));",
        
        "CREATE TABLE mod_documents_mod_files_relations (
        doc_id int(10) unsigned NOT NULL, 
        file_id int(10) unsigned NOT NULL, 
        PRIMARY KEY (doc_id,file_id));",
        
        "CREATE TABLE mod_documents_flag_relations (
        doc_id int(10) unsigned NOT NULL, 
        flag varchar(50) NOT NULL, 
        PRIMARY KEY (doc_id,flag));",
    ]
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "1 минута",
    comment => "Скрипт заполняет новую шардированную таблицу ppc.mod_files данными из таблицы ppcfiles.mod_licenses"
  }
]

=cut

use Direct::Modern;

use Yandex::DBShards;
use Yandex::DBTools;
use Yandex::DBShards;

use PrimitivesIds;
use ScriptHelper;
use Settings;

use POSIX qw/ceil/;

my $chunk_size = 1000;
my $chunk_cnt = 0;

$log->out('START');

my ($min_id, $max_id) = get_one_line_array_sql(PPCFILES, 'SELECT MIN(id), MAX(id) FROM mod_licenses');
my $chunks_amount = ceil(($max_id-$min_id)/$chunk_size);
$log->out("Total chunks amount $chunks_amount");
for (my $start_id = $min_id; $start_id <= $max_id; $start_id += $chunk_size) {
    my $finish_id = $start_id + $chunk_size - 1;
    my $res = get_all_sql(PPCFILES, ['SELECT uid, id as file_id, timecreated as uploaded_at, filename from mod_licenses', WHERE => {id__between => [$start_id, $finish_id]}]);
    $chunk_cnt += 1;
    $log->out("Get chunk $chunk_cnt of the $chunks_amount from PPCFILES.mod_files between id $start_id and $finish_id");

    foreach_shard uid => $res, by => 'uid', with_undef_shard =>1, sub {
        my ($shard, $res_chunk) = @_;

        if (!$shard) {
            foreach my $file_data (@$res_chunk) {
                $log->out("Skipped uid: $file_data->{uid} - UNKNOWN SHARD!");
            }
        } else {
            $log->out("Insert chunk $chunk_cnt into PPC.mod_files, shard $shard:");
            my $uid2clientid = get_key2clientid(uid => [map {$_->{uid}} @$res]);

            my $to_insert = [];
            foreach my $file_data (@$res_chunk) {
                $file_data->{ClientID} = $uid2clientid->{$file_data->{uid}};
                $log->out($file_data);
                if (defined $file_data->{ClientID}) {
                    push @$to_insert, [ $file_data->{ClientID}, $file_data->{file_id}, $file_data->{filename}, $file_data->{uploaded_at} ];
                } else {
                    $log->out("ClientID not found for file_id " .$file_data->{file_id}. ", uid " .$file_data->{uid});
                }
            }
            do_mass_insert_sql(PPC(shard => $shard), "INSERT IGNORE INTO mod_files (ClientID, file_id, filename, uploaded_at) values %s", $to_insert);
        }
    }
}

$log->out('FINISH');
