#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "пара секунд",
}

=cut

use warnings;
use strict;
use utf8;

use YAML;

use Mcb;
use Yandex::DBTools;

use Settings;
use ScriptHelper;

use open qw/:std :encoding(UTF-8)/;

$log->out('START');

my $data;
{
    local $/ = undef;
    $data = <DATA>;
}
my $translation_for = YAML::Load($data);
my $themes = Mcb::get_themes_list(product_type => 'mcb_turkish');
for my $theme (@$themes) {
    $theme->{lang} //= 'tr';    # костыль из-за того, что сейчас Mcb::get_themes_list не возвращает язык темы (это ошибка, исправляется в DIRECT-41115).
    my $old_name = $theme->{name};
    for ($theme->{name}) {
        s/^\s+//;
        s/\s+$//;
    }
    if (! $translation_for->{ $theme->{name} }) {
        $log->out("no translation for '$theme->{name}'");
        next;
    }
    $theme->{name} = $translation_for->{ $theme->{name} };
    Mcb::save_theme($theme);
    $log->out("renamed '$old_name' to '$theme->{name}'");
}

$log->out('FINISH');

# Орфография и пунктуация оригинальных названий тем заботливо сохранены.
__DATA__
---
ADSL providers and subscription: İnternet sağlayıcılar
Air tickets and airlines: Uçak biletleri ve havayolu şirketleri
All auto brands and subbrands: Tüm araba markaları ve alt markaları
'All brands, subbrands, product lines': 'Tüm markalar, alt markalar, ürün grupları'
Auto: Araba
Bank deposits: Banka mevduatı
Bank names: Banka isimleri
Brand: Marka
Brands  (Consumer Electronics): Markalar (Tüketici elektroniği ürünleri)
Brands (without consumer electronics): Markalar (Kurumsal elektronik ürünler)
Bus Travel Agencies: Otobüs Seyahat Acenteleri
Cable TV: Kablolu TV
Car credits: Araç kredisi
'Car parts, spares': Oto parçaları
Cellular operators (branded keywords + Generic)  + tariffs: GSM operatörleri (marka isimli anahtar sözcükler + Genel) + tarifeler
Commercial transport: Ticari araçlar
Computer accessories: Bilgisayar aksesuarları
Consumer electronics (Generic): Tüketici elektroniği ürünleri (Genel)
Credit Cards: Kredi kartları
Economy class: Ekonomi sınıfı
Electronics: Elektronik ürünler
Electronics retailers: Elektronik ürün perakendecileri
Entertaiment: Eğlence
Fast Food Chains: Fast Food zincirleri
Fast Food. Generic keywords: Fast Food. Genel anahtar sözcükler
Finance: Finans
Food and beverages: Yiyecek ve içecek
Food brands: Yiyecek markaları
Game consoles (generic+Brands): Oyun konsolları (genel + Markalar)
Gaming. Generic keywords: Bilgisayar oyunları. Genel anahtar sözcükler
Gaming. Titles of games: Bilgisayar oyunları. Oyun isimleri
Generic: Genel
Generic keywords: Genel anahtar sözcükler
Hotels: Oteller
Insurance: Sigorta
Middle-class: Orta sınıf
Mobile phones (generic + Brands): Cep telefonları (genel + Markalar)
Mortgage: Ev kredisi
Network equipment: Network ekipmanı
Notebooks and laptops (Generic + Brands): Dizüstü bilgisayarları (Genel + Markalar)
Other subcategories: Diğer alt kategoriler
Personal Care: Kişisel Bakım
Personal loans: Tüketici kredisi
Photo/video equipment (generic+Brand): Fotoğraf/video ekipmanı (genel + Marka)
Premium-class: Üst sınıf
Restaurants & Cafes (generic + Branded): Restoranlar ve Kafeler (genel + Marka)
Soft drinks ( Brand + Generic): Alkolsüz içecekler (Genel + Marka)
Sports: Spor
TOP films: En iyi filmler
'TV - generic': Televizyonlar
TV channels: TV kanalları
TV series: Diziler
Tablets: Tabletler
Telecom: Telekom
Top Retailers: En büyük perakendeciler
Tour operators and agencies: Tur operatörleri ve acenteleri
Tours and excursions: Turlar ve geziler
Travel: Seyahat
Travel Generic: Seyahat Genel
Tyres and disks: Lastikler ve jantlar
Video/online films. Generic keywords: Video/çevrimiçi filmler. Genel anahtar sözcükler
