#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "~ 1 сутки на devtest",
  comment => "
      На продакшене не применяем, пока не разобрались с тестированием.

      Можно убивать и перезапускать.
      Чтобы замедлить выполнение скрипта можно использовать параметр '--relaxed-times число'
      (по умолчанию 2, берётся время выполнения каждого запроса и после делается во столько раз большая пауза)
  "
}

=cut

use Direct::Modern;

use Try::Tiny;
use List::MoreUtils qw/all/;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

my $CHUNK_SIZE = 100_000;

sub relax($&); # wrapper around 'relaxed times => 2'

$log->out('START');

my $relaxed_times = 2;
GetOptions(
    'relaxed-times=i' => \$relaxed_times,
);
$relaxed_times = 2 unless defined $relaxed_times;

sub iterate_table_parallel {
    # XXX Stub
}

iterate_table_parallel(
    'banners', 'bid', $CHUNK_SIZE, $log,
    relax $relaxed_times, sub {
        my ($shard, $min, $max) = @_;
        my $affected = do_update_table(PPC(shard => $shard), 'banners',
                                       {
                                           href__dont_quote =>  q{concat('http://', href)},
                                           LastChange__dont_quote => 'LastChange',
                                       },
                                       where => { bid__between => [$min, $max],
                                                  href__not_rlike => 'https?://'});
        $log->out("Affected $affected while updating banners between $min and $max");
    },
);

iterate_table_parallel(
    'sitelinks_links', 'sl_id', $CHUNK_SIZE, $log,
    relax $relaxed_times, sub {
        my ($shard, $min, $max) = @_;
        my $affected = do_update_table(PPC(shard => $shard), 'sitelinks_links', {href__dont_quote =>  q{concat('http://', href)}},
                                       where => { sl_id__between => [$min, $max],
                                                  href__not_rlike => 'https?://'});
        $log->out("Affected $affected while updating sitelinks_links between $min and $max");
    },
);

$log->out('FINISH');

sub relax($&) {
    my ($relaxed_times, $sub) = @_;
    return sub {
        my @args = @_;
        relaxed times => $relaxed_times, sub {
            $sub->(@args);
        }
    }
}
