#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1-2 минуты',
  comment => 'исправляем currencyConverted на кампаниях, которые копировали от сконвертированных без копирования клиентов'
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::Overshard;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard_$shard]");

    $log->out('Fetching cids to fix');
    my $cids_to_fix = get_one_column_sql(PPC(shard => $shard), '
        SELECT c.cid
        FROM campaigns c
        INNER JOIN users u ON c.uid = u.uid
        INNER JOIN currency_convert_queue q ON q.ClientID = u.ClientID
        WHERE
            c.currency="RUB"
            AND c.currencyConverted="No"
            AND c.ProductID = 1475
            AND q.convert_type = "MODIFY"
        ');
    $log->out('Cids to set currencyConverted:', $cids_to_fix);

    $log->out('Updating');
    do_update_table(PPC(shard => $shard), 'campaigns', {currencyConverted => 'Yes'}, where => {cid => $cids_to_fix});
}

$log->out('FINISH');

