#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
[
{
  type => 'script',
  when => 'after',
  time_estimate => '1 минута',
  comment => q/
    Сбрасываем флаг is_related_keywords_enabled для лёгких, перешедших из профи.
    
    Проверкв:
    select cid from camp_options join campaigns using(cid) join users_options using(uid)
    where statuseasy="Yes" and is_related_keywords_enabled=1;

    Если выдаст какие-то cid-ы, перезапустить деплой. Можно с [мульти]параметром --cid
  /,
}
]

=cut

use warnings;
use strict;
use utf8;
use my_inc '..';

use Yandex::DBTools;
use Yandex::Retry;
use List::MoreUtils qw/natatime/;

use Settings;
use ScriptHelper;
use ShardingTools;


our $SELECT_CHUNK_SIZE = 10_000;
our $UPDATE_CHUNK_SIZE =  1_000;



$log->out('START');

my $SLEEP_COEF = 0.1;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
    'cid=i@' => \my @cids,
);

for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard$shard]");

    my $found_cids;
    my $cid_ptr = 0;
    do {
        relaxed times => $SLEEP_COEF, sub {
            $log->out("Fetching campaigns chunk from $cid_ptr");
            $found_cids = get_one_column_sql(PPC_HEAVY(shard => $shard), [
                    'SELECT cid FROM campaigns c
                    JOIN camp_options co USING(cid)
                    JOIN users_options uo USING(uid)',
                    WHERE => {
                        statusEasy => "Yes",
                        is_related_keywords_enabled => 1,
                        cid__gt => $cid_ptr,
                        (@cids ? (cid => \@cids) : ()),
                    },
                    'ORDER BY cid',
                    LIMIT => $SELECT_CHUNK_SIZE,
                ]);
            $log->out("Got " . @$found_cids . " campaigns");
            return if !@$found_cids;

            $cid_ptr = $found_cids->[-1];

            my $it = natatime $UPDATE_CHUNK_SIZE, @$found_cids;
            while (my @cids_to_update = $it->()) {
                my $updated_rows = do_update_table(PPC(shard => $shard), 'camp_options',
                    { is_related_keywords_enabled => 0 },
                    where => { cid => \@cids_to_update },
                );
                $log->out("Successfully set flag for $updated_rows campaigns");
            }
        };
    } while @$found_cids > 0;
}

$log->msg_prefix('');
$log->out('FINISH');
