#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
[
{
  type => 'script',
  when => 'after',
  time_estimate => '3 минуты',
  comment => q/
    Сбрасываем флаг is_related_keywords_enabled для турецких пользователей.
  /,
}
]

=cut

use my_inc '..';
use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;
use Yandex::ListUtils qw/chunks/;
use RBACElementary;
use RBAC2::Extended;

use Settings;
use ScriptHelper;
use geo_regions;

my $SLEEP_COEF = 0.1;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');
my $client_ids = get_one_column_sql(PPC(shard => 'all'),
                    ['select ClientID from clients', where => {country_region_id => $geo_regions::TR}]);                    
$log->out(sprintf "founded %d turkish clients", scalar @$client_ids);
foreach_shard(ClientID => $client_ids, chunk_size => 100, \&process_clients);
$log->out('FINISH');


sub process_clients {

    my ($shard, $client_ids) = @_;

    my $rbac = RBAC2::Extended->get_singleton(1);
    my $chiefs_uids = rbac_get_chief_reps_of_clients($client_ids);
    my $uids = [values %$chiefs_uids]; 
    my $cids = get_one_column_sql(PPC(shard => $shard),
                ["SELECT cid FROM campaigns c JOIN camp_options co USING(cid)",
                WHERE => {'c.uid' => $uids, 'co.is_related_keywords_enabled' => 1}]);
    $log->out(sprintf "founded %d wrong campaigns for %d clients", scalar(@$cids), scalar(@$client_ids));
    foreach my $chunk_cids (chunks $cids, 100) {
        $log->out("clear is_related_keywords_enabled flag from cids: " . join ",", @$chunk_cids);
        relaxed times => $SLEEP_COEF, sub {
            do_sql(PPC(shard => $shard),
                ["UPDATE campaigns c JOIN camp_options co USING(cid)
                SET c.statusBsSynced = 'No', co.is_related_keywords_enabled = 0",
                WHERE => {'c.cid' => $chunk_cids}]);
        }
    }
}
