#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'полминуты',
  comment => 'Восстанавливаем разъехавшийся ClientID в базе и в RBACе у angstrem-mebel2015',
}

=cut

my $CLIENT_UID = 304625451;
my $WRONG_CLIENTID = 6733732;
my $RIGHT_CLIENTID = 5785838;
my $MANAGER_UID = 131569694;

my $OPERATOR_UID = 1;

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;

use RBACDirect;
use RBAC2::Extended;
use User;

$log->out('START');

my $errcode;

$log->out('Connection to RBAC');
my $rbac = eval { RBAC2::Extended->get_singleton( $OPERATOR_UID ) } || $log->die("Can't init RBAC: $@");

do_in_transaction {
    $log->out('Updating users');
    create_update_user($CLIENT_UID, {ClientID => $RIGHT_CLIENTID});

    $log->out('Fetching client cids');
    my $campaigns = get_all_sql(PPC(uid => $CLIENT_UID), ['SELECT cid, ManagerUID FROM campaigns', WHERE => {uid => SHARD_IDS}]);
    $log->out('Got campaigns:', $campaigns);

    for my $camp (@$campaigns) {
        my $cid = $camp->{cid};

        $log->die("Bad manager for cid $cid") unless $camp->{ManagerUID} == $MANAGER_UID;

        $log->out("Dropping cid $cid in RBAC");
        $errcode = $rbac->Handle('RBAC_DropSCampaign', {
            manager_uid => $MANAGER_UID,
            client_uid  => $CLIENT_UID,
            client_id   => $WRONG_CLIENTID,
            objects     => [$cid],
        });
        $log->die($errcode) if $errcode;
    }

    $log->out('Unbinding manager');
    $errcode = $rbac->Handle('RBAC_UnbindManager', {manager_uid => $MANAGER_UID, client_id => $WRONG_CLIENTID});
    $log->die($errcode) if $errcode;

    $log->out('Dropping client');
    $errcode = $rbac->Handle('RBAC_DropClient', {client_id => $WRONG_CLIENTID});
    $log->die($errcode) if $errcode;

    $log->out('Recreating client');
    $errcode = rbac_create_manager_client($rbac, $MANAGER_UID, $CLIENT_UID, 0);
    $log->die($errcode) if $errcode;

    $log->out('Recreating campaigns');
    for my $camp (@$campaigns) {
        my $cid = $camp->{cid};

        $log->out("Recreating cid $cid in RBAC");
        $errcode = $rbac->Handle('RBAC_CreateSCampaign', {
            client_uid  => $CLIENT_UID,
            client_id   => $RIGHT_CLIENTID,
            manager_uid => $MANAGER_UID,
            objects     => [$cid],
        });
        $log->die($errcode) if $errcode;
    }

    $log->out('Commiting RBAC transaction');
    $errcode = $rbac->Commit;
    $log->die($errcode) if $errcode;
};

$log->out('FINISH');
