#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "130 секунд на dev7",
  comment => "при падении можно перезапускать"
}

=cut

use warnings;
use strict;
use utf8;

use BS::ResyncQueue qw//;
use JSON;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils;

use Settings;
use ScriptHelper;
use ShardingTools;

my $CHUNK_SIZE = 100;

$log->out('START');

my $OK_IM_CLIENTS = [qw/icq skype jabber mail_agent msn/];
my %im_client_not_in_cond = (
    im_client__not_in => $OK_IM_CLIENTS,
    _OR => {
        im_client__is_not_null => 1,
        im_login__is_not_null => 1,
    }
);

my $to_json = JSON->new()->utf8;
foreach my $shard (ppc_shards()) {
    my $vcards = get_all_sql(PPC(shard => $shard), ["select vcard_id, im_login, im_client FROM vcards", WHERE => \%im_client_not_in_cond]);

    my $chunk_number = 1;
    my $chunks_total = int(scalar(@$vcards) / $CHUNK_SIZE);
    foreach my $chunk (chunks($vcards, $CHUNK_SIZE)) {
        $log->msg_prefix("[shard $shard] chunk [" . $chunk_number++ . '/' . $chunks_total . ']: ');
        $log->out("Working on vcards:" . to_json($chunk));
        my $vcard_ids = [ map { $_->{vcard_id} } @$chunk];
        $log->out("Resyncing banners in bs");
        my $banners = get_all_sql(PPC(shard => $shard), ["select bid, cid, -5 AS priority FROM banners", WHERE => {vcard_id => $vcard_ids}]);

        # LastChanges поменяется автоматически по ON UPDATE
        # Перепошлем в БК
        BS::ResyncQueue::bs_resync($banners);

        do_update_table(PPC(shard => $shard), 'vcards',
            {
                im_client => undef,
                im_login => undef,
            },
            where => {
                %im_client_not_in_cond,
                vcard_id => $vcard_ids
            }
        );
    }
}

$log->out('FINISH');

