#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "40 минут",
  comment => "Возвращаем правильное значение phoneflag и statusSitelinksModerate для баннеров без визиток и сайтлинков в компаниях, отправленных через ленивую очередь"
}

=cut

use warnings;
use strict;
use utf8;

use ShardingTools qw/ppc_shards/;
use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use Settings;
use ScriptHelper;

$log->out('START');

foreach my $shard (ppc_shards()) {
    $log->out("Get bad bids from shard $shard");
    my $bad_bids = get_one_column_sql(PPC(shard => $shard), "SELECT bid FROM banners
                                                             WHERE (vcard_id IS NULL AND phoneflag != 'New')
                                                             OR (sitelinks_set_id IS NULL AND statusSitelinksModerate != 'New')");
    $log->out("Update phoneflag and statusSitelinksModerate for bids:");
    foreach my $chunk (chunks($bad_bids, 1_000)) {
        $log->out(@$chunk);
        do_sql(PPC(shard => $shard), ["UPDATE banners SET
                                       statusBsSynced = 'No',
                                       phoneflag = IF(vcard_id IS NULL AND phoneflag != 'New', 'New', phoneflag),
                                       statusSitelinksModerate = IF(sitelinks_set_id IS NULL AND statusSitelinksModerate != 'New', 'New', statusSitelinksModerate)",
                                       where => {'bid' => $chunk}]);
    }
}

$log->out('FINISH');
