#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "3 секунды",
  comment => "удаляем потерянные кампании для логина pobeda-aero2016 (uid = 287961434)"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBShards;
use Yandex::DBTools;

use Settings;
use ScriptHelper;

use ModerationQueue;
use PrimitivesIds;
use Tag;
use VCards;

my $uid = 287961434;
my $shard = 6;

$log->out('START');

my $cids = get_one_column_sql(PPC(shard => $shard),"SELECT cid FROM campaigns WHERE uid = $uid");
$log->out("Get campaigns for uid $uid: ".join(',', @$cids));
foreach my $cid (@$cids) {
    $log->out("delete campaign $cid");
    _del_camp_data($cid);
}

$log->out('FINISH');


=head2 _del_camp_data(cid)

    Удаляет кампанию и связанные с ней сущности.
    Считается, что удаление из RBAC уже произведено.

=cut
sub _del_camp_data {
    my ($cid) = @_;

    my $camp = get_one_line_sql(
        PPC(shard => $shard), "
        SELECT type AS mediaType
        FROM campaigns
        WHERE cid = ?
        ", $cid
    );

    my $vcards_to_delete = get_one_column_sql(PPC(shard => $shard), 'SELECT DISTINCT vcard_id FROM vcards WHERE cid = ?', $cid) || [];

    my @delete_by_cid = qw/campaigns camp_options user_campaigns_favorite camp_metrika_counters metrika_counters camp_marked_phones/;
    for my $table (@delete_by_cid) {
        do_delete_from_table(PPC(shard => $shard), $table, where => { cid => $cid });
    }
    # Удаляем метки;
    Tag::delete_campaign_tags($cid);

    if ( ($camp->{mediaType}||'text') eq 'text' ) {

        my $pids = get_pids(cid => $cid);
        my $bids = get_bids(cid => $cid);
        my $mbids = get_one_column_sql(PPC(shard => $shard), "select mbid from mediaplan_banners where cid = ?", $cid);

        my $now = Yandex::DateTime->now();
        do_mass_insert_sql(PPC(shard => $shard), "REPLACE INTO deleted_banners (bid, deleteTime) VALUES %s",
                           [map {[$_, $now]} @$bids]);

        do_delete_from_table(PPC(shard => $shard), 'banner_images', where => {bid => $bids}) if @$bids;
        do_delete_from_table(PPC(shard => $shard), 'banners', where => {cid=>$cid});
        do_delete_from_table(PPC(shard => $shard), 'bids_href_params', where => {cid=>$cid});
        do_delete_from_table(PPC(shard => $shard), 'bids', where => {cid=>$cid});
        do_delete_from_table(PPC(shard => $shard), 'bids_manual_prices', where => {cid=>$cid});
        do_delete_from_table(PPC(shard => $shard), 'bids_arc', where => {cid=>$cid});
        do_delete_from_table(PPC(shard => $shard), "bids_retargeting", where => {pid => $pids});

        do_delete_from_table(PPC(shard => $shard), 'group_params', where => {pid => $pids});
        do_delete_from_table(PPC(shard => $shard), 'phrases', where => {cid => $cid});

        do_delete_from_table(PPC(shard => $shard), 'mediaplan_bids_retargeting', where => {mbid => $mbids}) if @$mbids;
        do_delete_from_table(PPC(shard => $shard), 'mediaplan_banners', where => {cid=>$cid});
        do_delete_from_table(PPC(shard => $shard), 'mediaplan_bids', where => {cid=>$cid});
        do_delete_from_table(PPC(shard => $shard), 'mediaplan_banners_original', where => {cid=>$cid});
        do_delete_from_table(PPC(shard => $shard), 'redirect_check_queue', where => {object_id => $bids, object_type => 'banner'}) if @$bids;
        do_delete_from_table(PPC(shard => $shard), 'autobudget_forecast', where => {cid => $cid});

        do_delete_from_table(PPC(shard => $shard), 'mod_reasons', where => { id => $bids, type => [qw/banner contactinfo sitelinks_set image/]});
        do_delete_from_table(PPC(shard => $shard), 'mod_reasons', where => { id => $pids, type => [qw/phrases/]});
        do_delete_from_table(PPC(shard => $shard), 'mod_reasons', where => { id => $cid, type => [qw/campaign/]});

        do_delete_from_table(PPC(shard => $shard), 'mod_object_version', where => { cid => $cid });

        delete_shard(bid => $bids);
        delete_shard(pid => $pids);
        delete_shard(mediaplan_bid => $mbids) if @$mbids;

        del_banners_from_moderate($cid, $bids) if @$bids;
    } else {

        do_sql(PPC(shard => $shard), qq!
                DELETE mcb_phrases
                  FROM mcb_phrases, media_groups
                 WHERE mcb_phrases.mgid = media_groups.mgid
                   AND media_groups.cid = ?
            !, $cid);

        do_sql(PPC(shard => $shard), qq!
                DELETE media_banners, media_groups
                  FROM media_banners, media_groups
                 WHERE media_banners.mgid = media_groups.mgid
                   AND media_groups.cid = ?
            !, $cid);
    }

    # удаляем визитки вместе с адресами.
    VCards::delete_vcard_from_db($vcards_to_delete, skip_org_details => 1);

    delete_shard(cid => $cid);

    return 1;
}
