#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка суток',
  comment => 'Снимаем возможность конвертации без копирования у клиентов со скрытыми плательшиками
При падениях можно перезапускать в каждом необработанном шарде начиная с последнего обработанного ClientID параметрами --min-clientid AAA --shard-id BBB
ClientID и шард можно посмотреть в логе /var/www/ppc.yandex.ru/protected/logs/20150529_reset-modify-convert-for-hidden-payers.log.YYYYMMDD'
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;

use Primitives;
use Client::CurrencyTeaserData;
use ShardingTools;

$log->out('START');

my $MIN_CLIENTID = 0;
my @SHARDS;
extract_script_params(
    'min-clientid=i' => \$MIN_CLIENTID,
    'shard-id=i' => \@SHARDS,
);
@SHARDS = ppc_shards() unless @SHARDS;
$log->out("min-clientid is $MIN_CLIENTID");
$log->out('Working in shards: ' . join(', ', @SHARDS));

for my $shard (@SHARDS) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    $log->out('Fetching clients to check for hidden payers');
    my $clientids_to_check = get_one_column_sql(PPC(shard => $shard), ["
        SELECT ctfmt.ClientID
        FROM clients_to_force_multicurrency_teaser ctfmt
        LEFT JOIN currency_convert_queue q ON ctfmt.ClientID = q.ClientID
        LEFT JOIN clients cl ON ctfmt.ClientID = cl.ClientID
        WHERE
            ctfmt.modify_convert_allowed = 1
            AND q.ClientID IS NULL
            AND IFNULL(cl.work_currency, 'YND_FIXED') = 'YND_FIXED'
            AND ctfmt.ClientID >= $MIN_CLIENTID
        ORDER BY ctfmt.ClientID
    "]);
    $log->out('Got ' . scalar(@$clientids_to_check) . ' clients to check');

    $log->out('Fetching agencies for clients');
    my $clid2agid = Primitives::mass_get_client_first_agency($clientids_to_check);

    for my $client_id (@$clientids_to_check) {
        my $success = eval {
            my $agency_id = $clid2agid->{$client_id};

            $log->out("Fetching teaser data for ClientID $client_id and AgencyID " . ($agency_id // 0));
            my $country_currency_data;
            Client::CurrencyTeaserData::fetch_client_multicurrency_teaser_data($client_id, $agency_id, firm_country_currency_data_ref => \$country_currency_data);

            my $can_be_modify_converted = Client::CurrencyTeaserData::can_be_modify_converted($country_currency_data);
            if ($can_be_modify_converted) {
                $log->out("Client $client_id CAN be modify converted, lefting intact");
            } else {
                $log->out("Client $client_id CANNOT be modify converting, correcting teaser");
                do_update_table(PPC(shard => $shard), 'clients_to_force_multicurrency_teaser', {modify_convert_allowed => 0}, where => {ClientID => $client_id});
            }

            return 1;
        };
        if (!$success || $@) {
            $log->out("ERROR checking $client_id, skipping: $@");
        }
    }
}

$log->out('FINISH');

