#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'before',
    time_estimate => "10 sec",
    sql => [
        "alter table adi.vipurl add column create_time timestamp not null default current_timestamp",
        "update adi.vipurl set create_time = moderate_date where moderate_date is not null",
    ]
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "10 sec",
    comment => ""
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;

$log->out('START');

# пытаемся проставить максимально корректное время в vipurl.create_time
my $sth = exec_sql(PPCLOG, "
            SELECT date(measure_time), max(value)
              FROM monitor_targets t
                   JOIN monitor_values_day d USING (target_id)
             WHERE t.name = 'db.ppcdict.adi.vipurl.max_autoincr'
             GROUP BY 1
             ORDER BY 1
             ");
my $prev_id = 0;
while(my ($date, $max_id) = $sth->fetchrow_array) {
    $log->out("get $date / $max_id");
    do_update_table(PPCDICT_CATALOG, "vipurl",
                    {create_time => $date},
                    where => {OrderId__between => [$prev_id, $max_id]}
        );
    $prev_id = $max_id + 1;
}

$log->out('FINISH');

