#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
  {
    type => 'sql',
    webstop => "0",
    db => "ppcdict",
    when => 'before',
    time_estimate => "10 sec",
    sql => "alter table adi.vipurl add column login varchar(100) not null default '', add column user_ip_region int not null default 0"
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "1 час",
    comment => "можно перезапускать"
  }
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use Primitives;
use ScriptHelper;

$log->out('START');

my $sth = exec_sql(PPCDICT_CATALOG, "SELECT OrderID, uid FROM vipurl WHERE login = '' ORDER BY OrderId desc");
my %LOGINS;
while(my ($oid, $uid) = $sth->fetchrow_array) {
    my $login = $LOGINS{$uid} //= eval {get_login_by_uid_passport($uid)} // '';
    if ($login) {
        $log->out("Update orderid=$oid, set login=$login");
        do_update_table(PPCDICT_CATALOG, "vipurl", {login => $login}, where => {OrderID => $oid});
    }
}

$log->out('FINISH');

