#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '~ 15 минут',
  comment => 'заменяем скидки > 30% в статистике на реальные'
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools;
use DBStat ();

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("Fetching orders from shard $shard");
    my $data = get_all_sql(PPC_HEAVY(shard => $shard), 'SELECT OrderID, date FROM order_nds_discount WHERE discount > 0.3');
    $log->out('Got ' . scalar(@$data) . ' order-date pairs to fix');
    for my $row (@$data) {
        $log->out("Refreshing stat for OrderID = $row->{OrderID} date = $row->{date} in shard $shard");
        DBStat::ordstat_nds_discount([$row->{OrderID}], $row->{date}, $row->{date}, update_discounts => 1);
    }
}

$log->out('FINISH');
