#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '~ 1 минута',
  comment => 'фиксим дважды запакованные телефоны'
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools;
use BS::ResyncQueue;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("Fetching vcards from shard #$shard");
    my $phones = get_all_sql(PPC_HEAVY(shard => $shard), '
        SELECT vcard_id, cid, phone
        FROM vcards
        WHERE phone rlike "^##"
    ');
    $log->out('Got ' . scalar(@$phones) . ' phones');

    for my $item (@$phones) {
        my $phone = $item->{phone};
        $phone =~ s/^#+//;
        $phone =~ s/#+$//;
        $log->out("Vcard #$item->{vcard_id}: $item->{phone} -> $phone");
        do_update_table(PPC(shard => $shard), 'vcards',
            { phone => $phone },
            where => {
                vcard_id => $item->{vcard_id},
                phone => $item->{phone},
            },
        );

        my $bids = get_one_column_sql(PPC(shard => $shard), [
                'SELECT bid FROM banners',
                WHERE => { vcard_id => $item->{vcard_id} },
            ]);
        next if !@$bids;

        my $cnt = BS::ResyncQueue::bs_resync([ map {{cid => $item->{cid}, bid => $_, priority => -10}} @$bids ]);
        $log->out("Added $cnt banners to BS queue (cid=$item->{cid})");
    }
}

$log->out('FINISH');
