#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 секунд",
  comment => 'Переводим в професионнальный интерфейс лёгких ползователей, которые или уже заказали конвертацию или их поставили в очередь на принудительную конвертацию',
}

=cut

use Direct::Modern;
use Yandex::DBTools;

use Settings;
use ScriptHelper;
use Common;

$log->out('START');

$log->out('Fetching users to switch interface');
my $uids = get_one_column_sql(
    PPC(shard => 'all'), '
    SELECT uo.uid
    FROM currency_convert_queue q
    INNER JOIN users u ON q.ClientID = u.ClientID
    INNER JOIN users_options uo ON uo.uid = u.uid
    WHERE
            uo.statusEasy = "Yes"
        AND NOT q.success_page_accepted

    UNION DISTINCT

    SELECT uo.uid
    FROM force_currency_convert q
    INNER JOIN users u ON q.ClientID = u.ClientID
    INNER JOIN users_options uo ON uo.uid = u.uid
    WHERE
            uo.statusEasy = "Yes"
        AND q.convert_date IS NOT NULL
');

for my $uid (@$uids) {
    $log->out("Converting uid $uid to profi");
    Common::set_user_easiness($uid, easy => 0);
}

$log->out('FINISH');
