#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "меньше секунды",
  comment => "на разработческих и тестовых средах деплой может не сработать
    из-за отсутствия в БД специально созданных тестовых кампаний - это некритично
    к запуску в продакшене"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;

use EnvTools qw/is_beta/;
use FakeAdminTools ();
use geo_regions ();

$log->out('START');

my %all_prices_one = (
    price => 1,
    price_context => 1,
);

my @test_data = (
    {
        cid => (is_beta() ? 411150527 : 13356484),
        uid => 166689424,
        domain => 'www.holodilnik.ru',
        banner_bodies => [ 'Интернет-магазин низких цен. Доставка уже завтра! Спешите, у нас скидки!' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'URL', kind => 'exact', value => 'http://www.holodilnik.ru/washers/' },
                ],
                %all_prices_one,
            },
        ],  
    }, {
        cid => (is_beta() ? 411150527 : 13356484),
        uid => 166689424,
        domain => 'www.holodilnik.ru',
        banner_bodies => [ 'Огромный выбор холодильников и морозильников на Holodilnik.Ru. Доставка!' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'URL', kind => 'exact', value => 'http://www.holodilnik.ru/refrigerator/' },
                ],
                %all_prices_one,
            },
        ],  
    }, {
        cid => (is_beta() ? 411150527 : 13356484),
        uid => 166689424,
        domain => 'www.holodilnik.ru',
        banner_bodies => [ 'Интернет-магазин техники по низким ценам! Доставка сегодня! Скидки до 25%' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'URL', kind => 'not_exact', value => 'http://www.holodilnik.ru/refrigerator/' },
                    { type => 'URL', kind => 'not_exact', value => 'http://www.holodilnik.ru/washers/' },
                ],
                %all_prices_one,
            },
        ],
    ########################################
    }, {
        cid => (is_beta() ? 411150532 : 13356485),
        uid => 166689424,
        domain => 'ulmart.ru',
        banner_bodies => [ 'Ulmart - интернет-магазин компьютерной, бытовой техники и электроники!' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'any' },
                ],
                %all_prices_one,
            },
        ],  
    ########################################
    }, {
        cid => (is_beta() ? 411150542 : 13356486),
        uid => 166689424,
        domain => 'eldorado.ru',
        banner_bodies => [ 'Эльдорадо - территория низких цен. На этот товар действуют скидки!' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'any' },
                ],
                %all_prices_one,
            },
        ],  
    ########################################
    }, {
        cid => (is_beta() ? 411150557 : 13356487),
        uid => 166689424,
        domain => 'vseinstrumenti.ru',
        banner_bodies => [ 'Один из лучших интернет-магазинов инструментов и техники! Доставка по РФ!' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'URL', kind => 'exact', value => 'gaykoverty' },
                ],
                %all_prices_one,
            },
        ],  
    }, {
        cid => (is_beta() ? 411150557 : 13356487),
        uid => 166689424,
        domain => 'vseinstrumenti.ru',
        banner_bodies => [ 'Один из лучших интернет-магазинов инструментов и техники! Доставка по РФ!' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'domain', kind => 'exact', value => 'kondicionery.vseinstrumenti.ru' },
                ],
                %all_prices_one,
            },
        ],  
    }, {
        cid => (is_beta() ? 411150557 : 13356487),
        uid => 166689424,
        domain => 'vseinstrumenti.ru',
        banner_bodies => [ 'Интернет-магазин техники по низким ценам! Доставка сегодня! Скидки до 25%' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'URL', kind => 'not_exact', value => 'gaykoverty' },
                    { type => 'domain', kind => 'not_exact', value => 'kondicionery.vseinstrumenti.ru' },
                ],
                %all_prices_one,
            },
        ],  
    ########################################
    }, {
        cid => (is_beta() ? 411150567 : 13356489),
        uid => 166689424,
        domain => 'ozon.ru',
        banner_bodies => [ 'Ozon.Ru - один из крупнейших интернет-магазинов в России. Доставка. Скидки!' ],
        geo => $geo_regions::RUS,
        dynamic => [
            {
                condition => [
                    { type => 'any' },
                ],
                %all_prices_one,
            },
        ],  
    },
);

for my $data (@test_data) {
    $log->out({new_group => $data});
    my $new_pid = eval {
        FakeAdminTools::create_dynamic_adgroup(%$data);
    };
    $log->out({new_pid => $new_pid, '$@' => $@});
}

$log->out('FINISH');

