#!/usr/bin/perl
use my_inc '..';

=head1 DESCRIPTION

Удаляем все корректировки, которые связаны с несуществующими кампаниями (кампании были удалены).

=head1 DEPLOY

# approved by hrustyashko
# .migr
[
  {
    type => 'script',
    when => 'after',
    time_estimate => "10 секунд на devtest",
    comment => ''
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "1 час",
    comment => "Если после запуска в логах появилось 'Error in shards', то нужно запустить повторно.",
    script => "./deploy/20150629_create_hierarchical_multipliers_and_move_mobile_multiplier_data_here.pl"
  },
]

=cut

use Direct::Modern;
use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use Yandex::DBShards;
use ShardingTools;

use Settings;
use ScriptHelper;

$log->out('START');

foreach_shard_parallel_verbose(
    $log, sub {
        my ($shard) = @_;
        $log->out("Processing shard $shard");
        my $leftover_mults = get_all_sql(PPC(shard => $shard), [
            "select h.hierarchical_multiplier_id as id, h.type from hierarchical_multipliers h ",
            "left join campaigns c using (cid)",
            where => { 'c.cid__is_null' => 1 }
        ]);
        my $mults_by_type = {};
        for my $row (@$leftover_mults) {
            push @{$mults_by_type->{$row->{type}}}, $row->{id};
        }
        while (my ($type, $ids) = each %$mults_by_type) {
            my $affected = 0;
            for my $chunk (chunks($ids, 1000)) {
                if ($type eq 'mobile_multiplier') {
                    $affected += do_sql(PPC(shard => $shard), [
                        "delete from hierarchical_multipliers", where => { hierarchical_multiplier_id => $ids },
                    ]);
                } else {
                    # На проде пока нет данных других типов
                    $log->out("Unexpected type '$type', you should investigate");
                }
            }
            if ($affected) {
                $log->out("Deleted $affected sets of type '$type'");
            }
        }

        $log->out("Done with shard $shard");
    }
);

$log->out('FINISH');
