#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка часа',
  comment => 'проставляем для фраз-черновиков статус модерации с группы',
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils;
use Yandex::Retry;

use Settings;
use ScriptHelper;

my $SLEEP_COEF = 3;

$log->out('START');

$log->out('Reading pids');
my $pids_file = "$Settings::ROOT/deploy/20150716_change-bids-statusModerate.data";
open(my $fh, "<", $pids_file) or $log->die("can't open file $pids_file");

my @pids = <$fh>;
chomp @pids;
$log->out('Got ' . scalar(@pids) . ' pids');

foreach_shard pid => \@pids, chunk_size => 1_000, sub {
    my ($shard, $pids_chunk) = @_;

    my $shard_msg_prefix = $log->msg_prefix("[shard_$shard]");

    relaxed times => $SLEEP_COEF, sub {
        $log->out('Fixing pids:', $pids_chunk);
        my $updated_rows_cnt = do_sql(PPC(shard => $shard), ['
            UPDATE bids bi
            INNER JOIN phrases p ON p.pid = bi.pid
            SET bi.statusModerate = IF(p.statusModerate IN ("Yes","No"), p.statusModerate, bi.statusModerate),
                p.statusBsSynced = "No"
         ', WHERE => {
                'bi.statusModerate' => 'New',
                'bi.pid' => $pids_chunk,
            },
        ]);
        $log->out("Updated $updated_rows_cnt rows");
    };
};

$log->out('FINISH');

