#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
    [
        {
            type => 'sql',
            webstop => "1",
            db => "ppc:all",
            when => 'before',
            time_estimate => "10 min",
            sql => "alter table campaigns modify column autobudget_goal_id bigint unsigned DEFAULT NULL"
        },
        {
            type => 'script',
            when => 'after',
            time_estimate => '6 часов',
            comment => q[    
                Поддерживаемые параметры:
                    --one-shard - для тестовых систем, будет использован только первый шард
                    --test-only - запуск без применения альтера
                    
                Скрипт можно останавливать/перезапускать.
            ],
        }
    ]

=cut

use open ':std' => ':utf8';
use my_inc '..';
use Direct::Modern;

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use Tools;
use List::MoreUtils qw/all/;
use Getopt::Long;

my ($one_shard, $test_only);
GetOptions(
    'one-shard' => \$one_shard,
    'test-only' => \$test_only,
);

$log->out('START');

my $shards = [map { /^ppcstat:(\d+)$/ ? $1 : () } @{get_db_childs("ppcstat")}];
$shards = [shift @$shards] if $one_shard && @$shards;
my $result = foreach_shard_parallel shard => $shards, sub {

    my $shard_id = shift;
    my $shard = "ppcstat:${shard_id}";
 
    $log->out("starting process for $shard");

    my $log_file_name = get_script_name(shardid => $shard_id).".log";
    my $shard_log = Yandex::Log->new(log_file_name => $log_file_name, date_suf => '%Y%m%d');
    eval {
        $shard_log->out("$shard start");
        modify_column($shard, $shard_log);
        $shard_log->out("$shard finish");
        1;
    } or do {
        $shard_log->out("$shard: $@");
        die $@;
    }
};

$log->out("ppcstat:$_ exit status: ". ((all {$_} @{$result->{$_}}) ? "OK" : "ERROR")) for keys %$result;
$log->out('FINISH');


sub modify_column {
    my ($shard, $log) = @_;

    my $dbh = get_dbh($shard);

    my $alter = 'ALTER TABLE %s MODIFY COLUMN goal_id bigint unsigned NOT NULL';

    my $tables = get_one_column_sql($dbh, q{
            select TABLE_NAME
            from information_schema.columns
            where TABLE_SCHEMA = 'ppcstat_data'
                AND TABLE_NAME LIKE 'order_goals_%'
                AND COLUMN_NAME = 'goal_id' AND COLUMN_TYPE LIKE 'int%'});
    my ($q, $total) = (0, scalar @$tables);
    $log->out("$shard has $total tables");
    @{$dbh}{qw/PrintError RaiseError/} = (0, 1);
    foreach my $t (@$tables) {
        $log->out("altering table $t");
        unless ($test_only) {
            eval {
                do_sql($dbh, sprintf($alter, "ppcstat_data.${t}"));
                1;
            } or do {
                $log->out("$shard $t: $@");
            }
        }
        $log->out("$shard $q/$total tables done") unless ++$q % 1000;
    }
    
    my $order_goals_table = get_one_field_sql($dbh, q{
                                select TABLE_NAME
                                from information_schema.columns
                                where TABLE_SCHEMA = 'ppcstat'
                                    AND TABLE_NAME LIKE 'order_goals'
                                    AND COLUMN_NAME = 'goal_id' AND COLUMN_TYPE LIKE 'int%'
                            });
    if ($order_goals_table) {
        $log->out("altering table $order_goals_table");
        unless ($test_only) {
            eval {
                do_sql($dbh, sprintf($alter, $order_goals_table));
                1;
            } or do {
                $log->out("$shard $order_goals_table: $@");
            }
        }
    }
    
}
