#!/usr/bin/env perl

=head1 DEPLOY

# approved by pankovpv
# .migr
    [
        {
            type => 'sql',
            webstop => 0,
            db => "ppc:all",
            when => 'before',
            time_estimate => "менее секунды на devtest",
            comment => "в конце запроса добавить ,ALGORITHM=INPLACE, LOCK=NONE",
            sql => "ALTER TABLE campaigns MODIFY COLUMN type enum('text','mcb','geo','market','wallet','mobile_content','performance','dynamic') NOT NULL DEFAULT 'text'",
        },
        {
            type => 'sql',
            webstop => 0,
            db => "ppc:all",
            when => 'after',
            time_estimate => "менее секунды на devtest",
            sql => [
                "UPDATE banners b JOIN adgroups_dynamic gd ON (gd.pid = b.pid) SET b.banner_type='dynamic'",
                "UPDATE campaigns c JOIN phrases g ON (g.cid = c.cid) JOIN adgroups_dynamic gd ON (gd.pid = g.pid) SET c.type = 'dynamic'",
            ],
        },
        {
            type => 'script',
            when => 'after',
            time_estimate => '1-2 секунды',
            comment => "Останавливаем и архивируем текстовые баннеры в кампаниях с динамическими баннерами",
        }
    ]

=cut

use open ':std' => ':utf8';
use my_inc '..';
use Direct::Modern;

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;

use List::MoreUtils qw/uniq/;

use Models::AdGroup qw//;
use Common qw//;

$log->out('START');

my $adgroups_to_archive = get_all_sql(PPC(shard => 'all'), q{
    SELECT g.cid, g.pid
    FROM phrases g
    JOIN (SELECT DISTINCT g2.cid FROM phrases g2 JOIN adgroups_dynamic gd2 ON (gd2.pid = g2.pid)) cd ON (cd.cid = g.cid)
    WHERE g.adgroup_type != "dynamic"
});

if (@$adgroups_to_archive) {
    $log->out({'Found adgroups to stop and archive' => $adgroups_to_archive});

    no warnings 'redefine';
    local *Models::Banner::mass_mail_notification = sub {};
    use warnings 'redefine';

    my @adgroup_ids = map { $_->{pid} } @$adgroups_to_archive;

    Models::AdGroup::stop_groups(\@adgroup_ids);
    Common::mass_archive_banners(pids => \@adgroup_ids);
}

my $campaigns_to_fix = get_one_column_sql(PPC(shard => 'all'), q{
    SELECT DISTINCT g.cid FROM phrases g JOIN adgroups_dynamic gd ON (gd.pid = g.pid)
});

if (@$campaigns_to_fix) {
    $log->out({'Found campaigns to fix params' => $campaigns_to_fix});

    # Также, сбросим не доступные для динамических кампаний параметры
    do_in_transaction {
        do_update_table(PPC(cid => $campaigns_to_fix), 'campaigns', {
            autoOptimization => 'No',
            statusBsSynced => 'No',
        }, where => {cid => SHARD_IDS});

        do_update_table(PPC(cid => $campaigns_to_fix), 'camp_options', {
            is_related_keywords_enabled => 0,
            broad_match_limit => 0,
            broad_match_flag => 'No',
            fairAuction => 'No',
        }, where => {cid => SHARD_IDS});
    };

    $log->out('Done');
}

$log->out('FINISH');
