#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка получаса',
  comment => 'снимаем ошибочно поставленные statusYacobotDeleted с кампаний под общим счётом',
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::ListUtils qw(chunks);

use Settings;
use ScriptHelper;

use ShardingTools;

$log->out('START');

for my $shard (ppc_shards()) {
    my $log_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");

    $log->out('Fetching campaigns');
    my $all_cids = get_one_column_sql(PPC(shard => $shard), ['
        SELECT STRAIGHT_JOIN c.cid
        FROM camp_options co
        INNER JOIN campaigns c ON c.cid = co.cid
        INNER JOIN campaigns wc ON c.wallet_cid = wc.cid
        INNER JOIN users u ON c.uid = u.uid
        WHERE
                c.statusYacobotDeleted = "Yes"
            AND u.statusYandexAdv = "No"
            AND co.is_search_stop = 1
            AND c.sum + IFNULL(wc.sum, 0) - c.sum_spent - IFNULL(wc.sum_spent, 0) > 0
    ']);

    for my $cids_chunk (chunks $all_cids, 10) {
        $log->out('Updating cids chunk:', $cids_chunk);
        do_sql(PPC(shard => $shard), ["UPDATE campaigns c
                          join banners b using(cid)
                      SET c.statusYacobotDeleted = 'No'
                        , b.LastChange = now()",
                    WHERE => {'c.cid' => $cids_chunk, 'c.statusYacobotDeleted' => 'Yes'}]);
    }
}

$log->out('FINISH');
