#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
[
{
  type => 'sql',
  webstop => "0",
  db => "monitor",
  when => 'before',
  time_estimate => "1 час",
  comment => "можно делать без переключения, но лучше на всех серверах по-отдельности с SET SQL_LOG_BIN=0;",
  sql => "alter table clients_geo_ip_cache modify column ip varchar(40) NOT NULL"
},
{
  type => 'sql',
  webstop => "0",
  db => "ppcdict",
  when => 'before',
  time_estimate => "5 сек",
  sql => "alter table bad_ips modify column ip varchar(40) NOT NULL DEFAULT ''"
},
{
  type => 'sql',
  webstop => "0",
  db => "ppclog",
  when => 'before',
  time_estimate => "10 сек",
  sql => [
      "ALTER TABLE logoldrbac MODIFY COLUMN `ip` varchar(40) NOT NULL DEFAULT '', modify column uid bigint unsigned not null default 0",
      "CREATE TABLE logrbac_tmp LIKE logrbac",
      "ALTER TABLE logrbac_tmp MODIFY COLUMN `ip` varchar(40) NOT NULL DEFAULT '', ADD COLUMN reqid bigint unsigned not null default 0, modify column uid bigint unsigned not null default 0",
      "RENAME TABLE logrbac TO logrbac_to_delete, logrbac_tmp TO logrbac",
  ]
},
{
  type => 'script',
  when => 'after',
  time_estimate => "20 мин",
  comment => "перенос данных из logrbac_to_delete в logrbac"
}
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::TimeCommon;
use Yandex::Retry;

use Settings;
use ScriptHelper;

$log->out('START');

for my $date (get_distinct_dates("2005-01-01", today())) {
    $log->out("start process $date");
    relaxed times => 2, sub {
        do_insert_select_sql(PPCLOG, 
                             "INSERT INTO logrbac (name, state, retval, retvalstr, ip, logtime, uid) VALUES %s",
                             "SELECT name, state, retval, retvalstr, ip, logtime, uid
                                FROM logrbac_to_delete
                               WHERE logtime >= ? AND logtime < ? + interval 1 DAY
                             ", binds => [$date, $date]
            );
    };
}

$log->out('FINISH');

