#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка минуты',
  comment => 'исправляем разложенный для статистики график НДС для агентских нерезидентов',
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use DBStat ();

$log->out('START');

$log->out('Fetching orders to fix');
my $orders_data = get_all_sql(PPC(shard => 'all'), ['
    SELECT c.OrderID
         , ots.stat_date AS date_from
         , ots.stat_date AS date_to
    FROM clients_options co
    LEFT JOIN clients cl ON cl.ClientID = co.ClientID
    INNER JOIN users u ON co.ClientID = u.ClientID
    INNER JOIN campaigns c ON u.uid = c.uid
    INNER JOIN bs_order_target_stat ots ON ots.OrderID = c.OrderID
    WHERE
            co.non_resident = 1
        AND IFNULL(cl.work_currency, "YND_FIXED") != "YND_FIXED"
        AND c.OrderID > 0
        AND IFNULL(c.currency, "YND_FIXED") != "YND_FIXED"
        AND c.AgencyID > 0
']);
$log->out('Fixing ' . scalar(@$orders_data) . ' rows:', $orders_data);
DBStat::mass_ordstat_nds_discount($orders_data);

$log->out('FINISH');
