#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько секунд',
  comment => 'удаляем таблицы ppclog.logsuggestion_YYYYMMDD'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;

$log->out('START');

$log->out('Fetching tables to drop');
my $tables = get_one_column_sql(PPCLOG, 'SHOW TABLES LIKE "logsuggestion_%"');
$log->out('Got ' . scalar(@$tables) . ' tables to drop:', $tables);

for my $table (@$tables) {
    $log->out("Dropping table $table");
    do_sql(PPCLOG, "DROP TABLE $table");
}

$log->out('FINISH');
