#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка 40 секунд с дефолтным --sleep-coef 0.1',
  comment => 'Приводим "битые" позиции к правильному формату:
    Сначала доводим old_place и statusPlace до разрещенных значений
    Если позиции фраз по итогу оказались одинаковыми, то удаляем их, чтобы они не мозолили глаза пользователям.
             '
}

=cut

use constant SELECT_CHUNK_SIZE => 1_000;

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;

$log->out('START');

my $SLEEP_COEF = 0.1;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);


for my $shard (ppc_shards()) {
    $log->msg_prefix("[shard$shard]");
    my $uids=[];
    my $last_uid = 0;
    my $max_uid = get_one_field_sql(PPC_HEAVY(shard => $shard), "SELECT MAX(uid) FROM warnplace");
    do {
        relaxed times => $SLEEP_COEF, sub {
            $log->out('Fetching phrases chunk to fix');

            $uids = get_one_column_sql(PPC_HEAVY(shard => $shard), 
                'SELECT uid FROM warnplace WHERE uid >? AND uid <= ? ORDER BY uid LIMIT ? ', $last_uid, $max_uid, SELECT_CHUNK_SIZE);

            my $uids_cnt = scalar @$uids;
            $log->out("Got $uids_cnt users to fix");
            if ($uids_cnt) {
                $last_uid = $uids->[-1];
                # Обновляем позиции
                my $updates_cnt = do_update_table(PPC(shard=>$shard), 'warnplace', 
                    {old_place=>"IF(old_place IN(10,11,3), 12, IF(old_place IN (21,22,1), 23, IF (old_place=2, 20, old_place)))",
                     statusPlace=>"IF(statusPlace IN(10,11,3), 12, IF(statusPlace IN (21,22,1), 23, IF (statusPlace=2, 20, statusPlace)))",
                     addtime => "addtime"}, where => {uid => $uids}, dont_quote => ['old_place', 'statusPlace', 'addtime']);
                $log->out("updated $updates_cnt phrases");

                # Удаляем одинаковые позиции
                my $deleted_cnt = do_delete_from_table(PPC(shard=>$shard), 'warnplace', where => {_TEXT=>'old_place=statusPlace', uid => $uids});
                $log->out("Deleted $deleted_cnt phrases");
            }
        };
    } while @$uids > 0;
}
$log->msg_prefix('');

$log->out('FINISH');
