#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'несколько часов',
        comment => q[
            Добавляем новые ключевые поля `ConnectionType` и `DetailedDeviceType` в таблицы статистики ppcstat_data: order_stat_nnnnnnn

            Поддерживаемые параметры:
                --one-shard - для тестовых систем, будет использован только первый шард
                --test-only - запуск без применения альтера
                --skip-column-check - пропуск проверки наличия колонки ConnectionType и DetailedDeviceType в таблицах

            Скрипт можно останавливать/перезапускать.
            При первом запуске лучше указать --skip-column-check для экономии времени.
            После перезапуска можно --skip-column-check указывать также, но в этом случае в логах могут появиться сообщения о том,
            что нужные колонки уже были добавлены.
        ],
    }

=cut

use strict;
use warnings;

use my_inc '..';

use utf8;
use open ':std' => ':utf8';

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;
use Tools;

my ($one_shard, $test_only, $skip_column_check);
extract_script_params(
    'one-shard' => \$one_shard,
    'test-only' => \$test_only,
    'skip-column-check' => \$skip_column_check,
);

$log->out('START');

my $shards = get_db_childs("ppcstat");
$shards = [shift @$shards] if $one_shard && @$shards;

my $result = foreach_shard_parallel(shard => $shards, sub {
    my ($shard) = @_;
    $log->out("starting process for $shard");

    my ($shard_id) = ($shard =~ /^ppcstat:(\d+)$/);
    my $log_file_name = get_script_name(shardid => $shard_id).".log";
    $0 .= " SHARD - $shard_id";
    my $log = Yandex::Log->new(log_file_name => $log_file_name, date_suf => '%Y%m%d');
    eval {
        $log->out("$shard start");
        add_columns($shard, $log);
        $log->out("$shard finish");
        1;
    } or do {
        $log->out("$shard: $@");
    };
});

$log->out("$_ exit status: ".($result->{$_}->[0] ? "OK" : "ERROR")) for keys %$result;

$log->out('FINISH');

sub add_columns {
    my ($shard, $log) = @_;

    my $dbh = get_dbh($shard);

    my $alter = q{
        ALTER TABLE ppcstat_data.%s
            ADD COLUMN `DetailedDeviceType` tinyint(4) unsigned NOT NULL DEFAULT 0 AFTER `DeviceType`,
            ADD COLUMN `ConnectionType` tinyint(4) unsigned NOT NULL DEFAULT 0 AFTER `Gender`,
            DROP PRIMARY KEY,
            ADD PRIMARY KEY (`hitDate`,`BannerID`,`PhraseID`,`ContextType`,`region`,`PageID`,`TypeID`,`DeviceType`,`Age`,`Gender`,`DetailedDeviceType`,`ConnectionType`)
    };

    my $tables = get_one_column_sql($dbh, q{
        SELECT t.TABLE_NAME
        FROM information_schema.tables t
        WHERE
            t.TABLE_SCHEMA = "ppcstat_data" AND (}.join(' OR ', map { "t.TABLE_NAME LIKE \"${_}%\"" } qw/order_stat/).q{)
    });
    @$tables = grep { m/^order_stat_(n+|\d+)$/ } @$tables;
    my ($q, $total) = (0, scalar @$tables);

    $log->out("$shard has $total tables");
    @{$dbh}{qw/PrintError RaiseError/} = (0, 1);
    foreach my $t (@$tables) {
        my $is_altered = $skip_column_check ? 0 : get_one_field_sql($dbh, q{
            SELECT 1
            FROM information_schema.columns c
            WHERE
                c.TABLE_SCHEMA = "ppcstat_data" AND c.TABLE_NAME = ? AND c.COLUMN_NAME IN ("ConnectionType", "DetailedDeviceType")
            LIMIT 1
        }, $t);

        if (!$is_altered && !$test_only) {
            $log->out("altering table $t");
            eval {
                do_sql($dbh, sprintf($alter, $t));
                1;
            } or do {
                $log->out("$shard $t: $@");
            };
        }

        $log->out("$shard $q/$total tables done") unless ++$q % 1000;
    }
}
