#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "<примерное время выполнения>",
  comment => "
перед запуском нужно загрузить файл
scp ppcdev1:/home/zhur/bs-delete /tmp/bs-delete
"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::ListUtils;
use Yandex::DBTools;
use Yandex::DBShards;

use Settings;
use ScriptHelper;

$log->out('START');

open(my $fh, "/tmp/bs-delete") || die "Can't open /tmp/bs-delete: $!";
my %date2oids;
while(my $line = <$fh>) {
    my ($date, $oid) = split /\s/, $line;
    push @{$date2oids{$date}}, $oid;
}
close($fh);

while(my ($date, $oids) = each %date2oids) {
    foreach_shard OrderID => $oids, chunk_size => 1000, with_undef_shard => 1, sub {
        my ($shard, $chunk) = @_;
        my $msg_prefix_guard = $log->msg_prefix_guard("shard ". ($shard // 'no_shard'));
        if (!defined $shard) {
            $log->out({"undefined_shard" => $chunk});
            return;
        }
        my $where = {stat_date => $date, target_type => 0, OrderID => $chunk};
        $log->out({"do_delete" => $where});
        $log->out(get_all_sql(PPC(shard => $shard), ["SELECT * FROM bs_order_target_stat", where => $where]));
        my $ret = do_delete_from_table(PPC(shard => $shard), "bs_order_target_stat", where => $where);
        $log->out("deleted $ret rows");
    }
}

$log->out('FINISH');

