#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'полчаса-час',
  comment => 'перед запуском нужно привезти файл:
scp ppcdev1:/home/zhur/bs-bad /tmp/bs-bad
',
}

=cut

use Direct::Modern;

use Yandex::Shell qw(yash_system);
use Yandex::ListUtils qw(chunks nsort);

use Settings;
use ScriptHelper;

use List::MoreUtils qw(zip);

my $FILE = '/tmp/bs-bad';

$log->out('START');

my %date_orders;

$log->out('Collecting file data');
open(F, '<', $FILE) || $log->die($!);
my $status = <F>;
my $header = <F>;
$header =~ s/^#//;
my @fields = split /\t/, $header;
for my $line (<F>) {
    chomp $line;

    next if $line =~ /^#/;
    next if $line =~ /:/;

    my @values = split /\t/, $line;
    my %row = zip(@fields, @values);

    my $date = substr $row{UpdateTime}, 0, 8;
    my $orderid = $row{OrderID};

    $date_orders{$date}{$orderid} = undef;
}
close(F) || $log->die($!);

$log->out('Fixing data');
for my $date (nsort keys %date_orders) {
    my @orderids = nsort keys %{$date_orders{$date}};
    for my $orders_chunk (chunks(\@orderids, 100)) {
        my @orders_args = map { ('--orderid', $_) } @$orders_chunk;
        $log->out("Fixing data for date $date and orders:", $orders_chunk);
        yash_system("$Settings::ROOT/protected/one-shot/fix-bs_order_target_stat-data.pl", '--from' => $date, '--to' => $date, @orders_args, '--fix');
    }
}

$log->out('FINISH');
