#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '~ 25-35 минут',
  comment => 'плавно и методично проходим все кампании с маленьким sum_last, в логах баланса ищем для них платежи,
              похожие не на откат, а обычные пополнения. Проставляем этой суммой значение в campaigns.
              Делается для того, чтобы кампаниям начали наконец приходит уведомления о заканчивающихся деньгах.
              Можно запускать пошардово (на случай, если что-то пойдет не так). Можно запускать несколько раз.',
}

=cut

use constant SELECT_CHUNK_SIZE => 1_000;

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry;

use Settings;
use ScriptHelper;
use ShardingTools;
use Currencies;
use Currency::Rate;

$log->out('START');

my $SLEEP_COEF = 0.1;
my $SHARD;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
    'shard-id=s' => \$SHARD
);

my %min_payments = map {$_ => Currencies::get_currency_constant($_, 'MIN_PAY')} Currencies::get_currencies_list();
my @shards = ($SHARD) ? ($SHARD) : ppc_shards();
for my $shard (@shards) {
    $log->msg_prefix_guard("[shard $shard]");
    my $campaigns=[];
    my $last_cid = 0;
    my $max_cid = get_one_field_sql(PPC(shard => $shard), "SELECT MAX(cid) FROM campaigns");
    do {
        relaxed times => $SLEEP_COEF, sub {
            $log->out('Fetching campaigns chunk to fix');
            $campaigns = get_all_sql(PPC(shard => $shard), 
                ['SELECT cid, sum_last, currency FROM campaigns',
                  where => {cid__gt => $last_cid,
                            cid__le => $max_cid,
                            sum__gt => 0,
                            statusEmpty => 'No',
                            # выбираем меньше минимального платежа на валюту
                            sum_last__lt__dont_quote => sql_case('currency',\%min_payments),
                            archived => 'No',
                            type => 'wallet'}, 
                 'ORDER BY cid LIMIT ?'], SELECT_CHUNK_SIZE);

            my $cids_cnt = scalar @$campaigns;
            $log->out("Got $cids_cnt campaigns to fix");
            if ($cids_cnt) {
                $last_cid = $campaigns->[-1]->{cid};
                foreach my $camp (@$campaigns) {
                    if ($camp->{sum_last} < $min_payments{$camp->{currency}}) {
                        my $logbalance_data = get_one_line_sql(PPCLOG, "SELECT sum_delta, currency 
                                              FROM logbalance WHERE cid=? AND sum_delta>? ORDER BY logtime DESC LIMIT 1",
                                               $camp->{cid}, $min_payments{$camp->{currency}});
                        if ($logbalance_data) {
                            my $new_sum_delta = $logbalance_data->{sum_delta};
                            if ($camp->{currency} ne $logbalance_data->{currency}) {
                                $new_sum_delta = convert_currency($logbalance_data->{sum_delta},
                                                                  $logbalance_data->{currency},
                                                                  $camp->{currency},
                                                                  with_nds => 1);
                                $log->out(sprintf ("Currencies aren't the same: converted %f %s to %f %s",
                                          $logbalance_data->{sum_delta}, $logbalance_data->{currency},
                                          $new_sum_delta, $camp->{currency}));
                            }
                            my $updates_cnt = do_update_table(PPC(shard=>$shard), 'campaigns',
                              {sum_last => $new_sum_delta, LastChange__dont_quote => "LastChange"},
                               where => {cid => $camp->{cid}});
                            $log->out(sprintf("updated campaign %d: old sum_last: %f, new sum_last: %f %s", $camp->{cid}, $camp->{sum_last}, $new_sum_delta, $camp->{currency}));
                        } else {
                            $log->out(sprintf("couldn't find actual sum_last for campaign %d", $camp->{cid}));

                        }
                    }
                }
            }
        };
    } while @$campaigns > 0;
}

$log->out('FINISH');
