#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr

{
  type => 'script',
  when => 'after',
  time_estimate => "10 секунд",
  comment => "Исправляем запись в метабазе",
}

=cut

use Direct::Modern;
use my_inc "..";

use Settings;
use Yandex::DBTools;
use Yandex::DBShards;
use ScriptHelper;


my %CLIENT_ID_MAP = (
    5333451 => 442805,
);

$log->out('START');

while (my ($wrong_client_id, $new_client_id) = each %CLIENT_ID_MAP) {
    my $right_shard = get_shard(ClientID => $new_client_id);
    $log->out("Fixing shard for $wrong_client_id: new value $right_shard");
    save_shard(ClientID => $wrong_client_id, shard => $right_shard);
    $log->out("Replacing ClientID $wrong_client_id -> $new_client_id");
    update_shard_chain('ClientID', $wrong_client_id, $new_client_id);
}

$log->out('FINISH');

