#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by lena-san
# .migr
[
{
  type => 'sql',
  webstop => 0,
  db => 'ppc:all',
  when => 'before',
  time_estimate => '1 секунда',
  sql => qq{
    alter table mds_metadata change type type enum('perf_feeds','banner_images_uploads') not null
  },
},
{
  type => 'script',
  when => 'after',
  time_estimate => "1 час",
  comment => "
На ТС запускать не обязятельно, но можно по необходимости, если потребуется показывать картинки, залитые ранее.
Картинки - временные файлы со сроком жизни 2 суток, так что их отсутствие в хранилище не должно вызывать проблем

Если нужно перезапустить: взять из лога последний id и передать в качестве позиционного параметра
(строчка в логе будет начинаться с id=NNN)

С ключом -o не будет падать, если файл уже существует
"
}
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;

use Direct::Storage;
use PrimitivesIds qw/get_clientid/;
use EnvTools qw/is_beta/;
use Getopt::Long;

$log->out('START');

my $storage = Direct::Storage->new();

my $ALLOW_OVERWRITE = 0;
GetOptions("o" => \$ALLOW_OVERWRITE);

my $start_id = shift // 0;

get_dbh(PPCFILES)->{mysql_use_result} = 1;
my $sth = exec_sql(PPCFILES, ["select id, uid, filename, file_data from banner_images_uploads", where => { id__gt => $start_id }, 'order by id']);
while (my $row = $sth->fetchrow_hashref()) {
    my $client_id = get_clientid(uid => $row->{uid});
    unless ($client_id) {
        $log->die("can not find ClientID for uid = $row->{uid}");
    }
    if ($ALLOW_OVERWRITE) {
        $storage->get_or_save('banner_images_uploads', $client_id, $row->{filename}, $row->{file_data});
    }
    else {
        $storage->save('banner_images_uploads', $client_id, $row->{filename}, $row->{file_data});
    }
    
    $log->out("id = $row->{id}, uid = $row->{uid}, name = $row->{filename}, length = ".(length($row->{file_data})));
}

$log->out('FINISH');

