#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '~ 5 минут',
  comment => 'не архивируем геоконтекстовые баннеры'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use ScriptHelper;
use JSON;
use Common qw/mass_unarchive_banners/;

use Settings;


$log->out('START');

# баннеров всего пара десятков, грузим все скопом
my $bids = get_one_column_sql(PPC(shard => 'all'),
        'select straight_join bid
        from campaigns c
        join banners b using(cid)
        where b.statusArch="Yes" and c.type="geo"'
    );

$log->out("Banners to unarchive: " . to_json($bids));

mass_unarchive_banners($Settings::GEOCONTEXT_SUPER_UID, bids => $bids);

$log->out('FINISH');
