#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'полминуты-минута',
  comment => 'исправляем statusModerate для кошельков',
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools qw(ppc_shards);

$log->out('START');

my %cond = (
    type => 'wallet',
    statusModerate__ne => 'Yes',
);

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out('Fetching wallets to fix');
    my $wallets = get_all_sql(PPC(shard => $shard), ['
        SELECT c.cid, c.statusModerate
        FROM campaigns c
    ',  WHERE => \%cond]);
    my @cids = map { $_->{cid} } @$wallets;
    $log->out('Got ' . scalar(@cids) . ' wallets to fix:', $wallets);

    $log->out('Fixing statusModerate');
    do_update_table(PPC(shard => $shard), 'campaigns', {
        statusModerate => 'Yes',
        statusBsSynced => 'No',
    }, where => {
        %cond,
        cid => \@cids,
    });
}

$log->out('FINISH');
