#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'минута-другая',
  comment => 'Доконвертируем пропущенные при конвертации динамические/мобильные кампании',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::HashUtils;
use Yandex::TimeCommon;
use Yandex::Balance qw(balance_get_completion_history balance_get_orders_info);
use Yandex::ListUtils qw(xsort chunks);
use Yandex::HashUtils;

use Settings;
use ScriptHelper;
use ShardingTools qw(ppc_shards);
use Direct::Gearman::Currency::ConvertToRealMoney ();

use RBAC2::Extended;
use RBACElementary;
use RBACDirect;
use Campaign;
use Client;
use Client::ConvertToRealMoney;
use Common;
use CampAutoPrice::Common;
use Currencies;
use Currency::Rate;
use MoneyTransfer;
use PrimitivesIds;
use Notification;
use DBLog;
use Campaign::Types qw(get_camp_kind_types);

my $OPERATOR_UID = 0;

$log->out('START');

for my $shard (ppc_shards()) {
    my $shard_prefix = "[shard_$shard]";
    my $msg_prefix_guard = $log->msg_prefix_guard($shard_prefix);

    $log->out('Fetching campaigns to fix');
    my $campaigns = get_all_sql(PPC(shard => $shard), ['
        SELECT c.cid, q.ClientID,
               q.uid, q.convert_type,
               q.state, q.new_currency,
               q.country_region_id, q.email,
               q.start_convert_at
        FROM currency_convert_queue q
        INNER JOIN users u ON q.ClientID = u.ClientID
        INNER JOIN campaigns c ON u.uid = c.uid
    ',  WHERE => {
        'q.convert_type' => 'MODIFY',
        'q.state' => 'DONE',
        'c.currencyConverted' => 'No',
        'c.type' => get_camp_kind_types('currency_convert'),
        _TEXT => 'IFNULL(c.currency, "YND_FIXED") = "YND_FIXED"',
    }]);
    $log->out('Got ' . scalar(@$campaigns) . ' campaigns to fix:', $campaigns);

    for my $camp (@$campaigns) {
        my $cid = $camp->{cid};
        my $cid_msg_prefix_guard = $log->msg_prefix_guard("$shard_prefix\t[cid_$cid]");
        $log->out('Converting campaign');
        _convert_campaign_inplace($camp);
    }
}

$log->out('FINISH');


=head2 _convert_campaign_inplace

=cut

sub _convert_campaign_inplace {
    my ($camp) = @_;

    my $cid = $camp->{cid};
    my $client_id = $camp->{ClientID};
    my $data = hash_cut $camp, qw(ClientID uid convert_type state new_currency country_region_id email start_convert_at);
    my $currency = $data->{new_currency};
    my $client_msg_prefix = "[copy_convert_bids_and_stop_campaigns] [ClientID $client_id]";

    # дальше сплошная копипаста из Direct::Gearman::Currency::ConvertToRealMoney::convert_client_inplace

    my $rbac = Direct::Gearman::Currency::ConvertToRealMoney::_get_rbac_object();
    my $cond = {
                'c.type' => get_camp_kind_types('currency_convert'),
                'c.currencyConverted' => "No",
                _TEXT => 'IFNULL(c.currency, "YND_FIXED") = "YND_FIXED"',
                'c.cid' => $cid, # не копипаста, добавлено в миграции
    };

    my $campaigns_data = Common::get_user_camps_by_sql($cond, {shard => {ClientID => $client_id}, include_empty_campaigns => 1});
    my $campaigns = $campaigns_data->{campaigns};
    $log->out('Got ' . scalar(@$campaigns) . ' campaigns from DB to convert');

    my @cids = map {$_->{cid}} @$campaigns;
    clear_auto_price_queue(\@cids, error_str => 'currency convert');

    my $rate = convert_currency(1, 'YND_FIXED', $currency);
    my $rate_nds = convert_currency(1, 'YND_FIXED', $currency, with_nds => 1);

    my $migrate_datetime = Direct::Gearman::Currency::ConvertToRealMoney::_get_migrate_date($data->{start_convert_at}, $data->{convert_type});
    my $first_date_in_real_currency = mysql_round_day($migrate_datetime);

    $log->out('Fetching chips cost/spent from Balance to update in DB');
    for my $cids_chunk (chunks \@cids, 10) {
        my $cids_chunk_str = join(',', @$cids_chunk);
        $log->out("Fetching chips cost/spent for cids chunk: $cids_chunk_str");
        my $balance_info_chunk = balance_get_orders_info($cids_chunk);
        my @for_insert;
        for my $order (@$balance_info_chunk) {
            $log->out($order);
            my $cid = $order->{ServiceOrderID};
            my $chips_cost = $order->{CompletionFixedMoneyQty} // $order->{CompletionMoneyQty};
            my $chips_spent = $order->{CompletionFixedQty} // $order->{completion_qty} // 0;
            push @for_insert, [$cid, $chips_cost, $chips_spent];
        }
        $log->out("Updating chips cost/spent in DB for cids chunk $cids_chunk_str");
        do_mass_insert_sql(PPC(ClientID => $client_id), '
            INSERT INTO campaigns_multicurrency_sums
                (cid, chips_cost, chips_spent) VALUES %s
            ON DUPLICATE KEY UPDATE
                chips_cost = VALUES(chips_cost),
                chips_spent = VALUES(chips_spent)
        ', \@for_insert);
    }

    $log->out('Begin converting campaigns');

    my $campaigns_multicurrency_sums_data = get_hashes_hash_sql(PPC(ClientID => $client_id), ['SELECT cid, sum, chips_cost FROM campaigns_multicurrency_sums', WHERE => {cid => \@cids}]);
    for my $campaign (@$campaigns) {
        my $cid = $campaign->{cid};
        $log->msg_prefix("$client_msg_prefix [cid $cid]");

        my $converted_campaign_params = Client::ConvertToRealMoney::get_converted_campaign_params($campaign, $currency, $rate, keep_ProductID => 1, copy_last_bill_sums => 1, save_conversion_strategy => 1);

        # берём сохранённые суммы для кампании в валюте, которые получаем в нотификациях от Баланса
        my $campaign_multicurrency_sums_data = $campaigns_multicurrency_sums_data->{$cid};
        my $new_sum_spent = ($campaign_multicurrency_sums_data) ? $campaign_multicurrency_sums_data->{chips_cost} // 0 : 0;
        my $new_sum = ($campaign_multicurrency_sums_data) ? $campaign_multicurrency_sums_data->{sum} // 0 : 0;

        $converted_campaign_params->{campaigns}->{sum} = $new_sum;
        $converted_campaign_params->{campaigns}->{sum_spent} = $new_sum_spent;
        $converted_campaign_params->{campaigns}->{balance_tid} = 0;
        $log->out('Converted params:', $converted_campaign_params);

        $log->out("Logging new campaign sum $new_sum");
        DBLog::log_balance($data->{uid}, $cid, $new_sum, 0, 0, $campaign->{mediaType}, $campaign->{currency});

        $log->out('Converting campaign');

        do_in_transaction {
            # лочим валюту в campaigns. в других местах можно также выбрать кампанию с FOR UPDATE и добиться последовательного выполнения транзакции на построчном локе.
            my $campaign_currency = get_one_field_sql(PPC(ClientID => $client_id), ['SELECT currency FROM campaigns', WHERE => {cid => $cid}, 'FOR UPDATE']);
            $log->die("Campaign $cid is already in $campaign_currency. That's VERY strange =)") if $campaign_currency && $campaign_currency ne 'YND_FIXED';

            Client::ConvertToRealMoney::convert_campaign_bids([$cid], 'YND_FIXED', $currency);
            Client::ConvertToRealMoney::convert_campaign_secondary_options([$cid], 'YND_FIXED', $currency);

            if ($converted_campaign_params->{camp_options} && %{$converted_campaign_params->{camp_options}}) {
                do_update_table(PPC(ClientID => $client_id), 'camp_options', $converted_campaign_params->{camp_options}, where => {cid => $cid});
            }
            do_update_table(PPC(ClientID => $client_id), 'campaigns', {
                currencyConverted => 'Yes',
                # прогноз сконвертировали по курсу, но ставки могли вырасти (больше минимальная ставка), да и шаг торгов другой — надёжнее пересчитать
                autobudgetForecastDate => undef,
                statusBsSynced => 'No',
                %{$converted_campaign_params->{campaigns}}
            }, where => {cid => $cid});
            # записываем суммы до конвертации и после, чтобы показывать их на странице успеха
            my $money_before = $campaign->{total};
            my $money_after = $new_sum - $new_sum_spent;
            $log->out("Writing correspondence data for campaign $cid: money_before = $money_before, money_after = $money_after");
            do_insert_into_table(PPC(ClientID => $client_id), 'currency_convert_money_correspondence', {
                ClientID => $client_id,
                old_cid => $cid,
                new_cid => $cid,
                money_before => $money_before,
                money_after => $money_after,
                was_archived => ($campaign->{archived} && $campaign->{archived} eq 'Yes') ? 1 : 0,
            }, on_duplicate_key_update => 1, key => 'ClientID');

            # multicurrency: monitor.agency_clients_month_stat
            # multicurrency: ppc.stopped_camp_users
            # multicurrency: конвертировать данные в ppc.serviced_client_budget

            # конвертируем грубый прогноз приблизительно. через небольшое время он пересчитается в ppcCampSpentForecast.pl
            do_update_table(PPC(ClientID => $client_id), 'camp_rough_forecast', {'forecast_sum__dont_quote' => "forecast_sum*$rate", forecast_time__dont_quote => 'forecast_time'}, where => {cid => $cid});
        };

        if ($campaign->{OrderID} && $campaign->{OrderID} > 0) {
            $log->out("Converting non-detailed stat (OrderID = $campaign->{OrderID}) with rate = $rate_nds");
            Client::ConvertToRealMoney::convert_nondetailed_stat($campaign->{OrderID}, $rate_nds);
        }

        $log->out('Done converting campaign');
    }
    $log->msg_prefix($client_msg_prefix);
    $log->out('Done converting campaigns');
}
