#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1 минута',
  comment => '  
    удаляем не значимые концевые пробелы в mobile-content
  ',
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools qw(ppc_shards);
use TextTools qw/smartstrip2/;
use Getopt::Long;

$log->out('START');

GetOptions(
    "dry-run" => \my $DRY_RUN,
);

for my $shard (ppc_shards()) {
    my $contents = get_all_sql(PPC(shard => $shard), "SELECT mobile_content_id, store_content_id FROM mobile_content");
    my ($processed, $total) = (0, scalar @$contents);
    $log->out(sprintf "selected %d contents", $total);
    for my $content (@$contents) {
        my $new_store_content_id = smartstrip2($content->{store_content_id}); 
        if ($new_store_content_id ne $content->{store_content_id}) {
            $log->out(sprintf 'fixing store_content_id for mobile_content_id = %d', $content->{mobile_content_id});
            $log->out(sprintf 'mobile_content_id=%d;old_store_content_id="%s";new_store_content_id="%s"',
                        $content->{mobile_content_id}, $content->{store_content_id}, $new_store_content_id);
            unless ($DRY_RUN) {
                do_update_table(
                    PPC(shard => $shard), 'mobile_content',
                    {
                        store_content_id => $new_store_content_id,
                        modify_time__dont_quote => 'create_time',
                        statusBsSynced => 'No',
                        statusIconModerate => 'Ready' 
                    },
                    where => {mobile_content_id => $content->{mobile_content_id}}
                );
            }
        }
        ++$processed;
        $log->out(sprintf 'processed %d/%d', $processed, $total) if $processed % 50 == 0;          
    }
}

$log->out('FINISH');
