#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by lena-san
# .migr
[
{
  type => 'sql',
  webstop => "0",
  db => "ppc:all",
  when => 'before',
  time_estimate => "1 секунда",
  sql => [
      "create table mds_custom_names (
            id bigint(20) unsigned primary key AUTO_INCREMENT,
            mds_id bigint(20) unsigned not null,
            filename varchar(255) not null,
            CONSTRAINT FOREIGN KEY (`mds_id`) REFERENCES `mds_metadata` (`id`),
            unique(mds_id, filename)
        )
      ",
      "alter table mds_metadata add column file_imprint varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL after filename",
  ]
},
{
  type => 'sql',
  webstop => "0",
  db => "ppcdict",
  when => 'before',
  time_estimate => "1 секунда",
  sql => [
      q!
        CREATE TABLE `mds_metadata` (
          `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
          `storage_host` enum('storage-int.mds.yandex.net','storage-int.mdst.yandex.net') NOT NULL,
          `ClientID` int(10) NOT NULL,
          `type` enum('common_file_export') NOT NULL,
          `filename` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
          `file_imprint` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
          `size` int(10) NOT NULL,
          `mds_key` varchar(300) NOT NULL,
          `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
          PRIMARY KEY (`id`),
          UNIQUE KEY `ClientID` (`ClientID`,`type`,`filename`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8
      !,
      "create table mds_custom_names (
            id bigint(20) unsigned primary key AUTO_INCREMENT,
            mds_id bigint(20) unsigned not null,
            filename varchar(255) not null,
            CONSTRAINT FOREIGN KEY (`mds_id`) REFERENCES `mds_metadata` (`id`),
            unique(mds_id, filename)
        )
      ",
  ]
},
{
  type => 'sql',
  webstop => "0",
  db => "ppc:all",
  when => 'after',
  time_estimate => "1 секунда",
  sql => [
      "update mds_metadata set file_imprint = filename",
      "alter table mds_metadata add unique key(`ClientID`, `type`, `file_imprint`)",
  ]
},

{
  type => 'script',
  when => 'after',
  time_estimate => "10 секунд",
  comment => "
Переливаем файлы из common_file_export в MDS

Можно перезапускать
"
},
{
  type => 'sql',
  webstop => "0",
  db => "ppcfiles",
  when => 'after',
  time_estimate => "1 секунда",
  sql => [
      "rename table common_file_export to common_file_export_to_delete",
  ],
  comment => '
    в таблице всего два файла, к которым обращаются реже чем раз в день
    поэтому выкладываемся в один этап
  ',
},
{
    type => 'manual',
    when => 'instructions',
    time_estimate => '10 min',
    instructions => 'ТОЛЬКО на ТС, до и после выкладки пакетов',
    text => q!
Перед выкладкой пакетов запустить скрипты
protected/ppcExportVcardsToBacka.pl --debug
protected/ppcExportDomainPhones.pl --limit 100

# не обязательно на ТС
curl -s 'http://test-direct.yandex.ru:9443/GetExportFile?id=direct_vcards_export' > direct_vcards_export.before
curl -s 'http://test-direct.yandex.ru:9443/GetExportFile?id=direct_domain_phones' > direct_domain_phones.before

после того, как отработает скрипт:

curl -s 'http://test-direct.yandex.ru:9443/GetExportFile?id=direct_vcards_export' > direct_vcards_export.after
curl -s 'http://test-direct.yandex.ru:9443/GetExportFile?id=direct_domain_phones' > direct_domain_phones.after

md5sum *.before *.after
Результат написать в DIRECT-47459
Убедиться, что хеш-суммы совпадают, если нет - сообщить разработчику
    !,
}
]

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use Direct::Storage;

$log->out('START');

my $files = get_all_sql(PPCFILES, 'select * from common_file_export');
$log->out('selected '.(scalar @$files).' files');

my $storage = Direct::Storage->new();
for my $f (@$files) {
    $storage->save('common_file_export', $f->{file_data}, filename => $f->{filename});
    $log->out("saved $f->{filename}");
}

$log->out('FINISH');

