#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '40 минут',
  comment => 'выкидываем кеш детальной статистики за доконвертационный период по сконвертированным без копирования кампаниям',
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use ShardingTools;
use Stat::Const;

$log->out('START');

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out('Fetching orders to refresh stat');
    my $orderids = get_one_column_sql(PPC(shard => $shard), ['
        SELECT DISTINCT c.OrderID
        FROM currency_convert_queue q
        INNER JOIN client_discounts d ON d.ClientID = q.ClientID
        INNER JOIN users u ON q.ClientID = u.ClientID
        INNER JOIN campaigns c ON u.uid = c.uid
        INNER JOIN bs_order_target_stat s ON s.OrderID = c.OrderID AND s.stat_date < q.start_convert_at
        WHERE q.convert_type = "MODIFY"
          AND q.state = "DONE"
          AND c.currency = "RUB"
          AND c.currencyConverted = "Yes"
          AND c.OrderID > 0
          AND d.discount > 0
    ']);
    $log->out('Got ' . scalar(@$orderids) . ' orders to rollback');

    $log->out('Inserting stat_rollbacks records');
    do_mass_insert_sql(PPCDICT, 'insert into stat_rollbacks ( OrderID, border_date, needCompleteSync ) values %s'
                            , [ map { [$_, $Stat::Const::BEGIN_OF_TIME_FOR_STAT, 'Yes'] } @$orderids ]
                        );

}

$log->out('FINISH');
