#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 мин",
  comment => "можно перезапускать"
}

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;

use Settings;
use ScriptHelper;
use PrimitivesIds;

use API::ClientOptions;

$log->out('START');

my $uids = get_one_column_sql(PPCLOG_HEAVY, "select uid
                                         from logapi_20151026
                                        where cmd = 'GetForecastList' 
                                              and interface = 'soap' 
                                              and uid > 300000000
                                        group by 1
                                              having count(*) > 100");

for my $uid (@$uids) {
    my $login = get_login(uid => $uid);
    if (!defined $login) {
        $log->out("No login for uid $uid - skip");
        next;
    }
    my $ClientID = get_clientid(uid => $uid);
    if (!defined $ClientID) {
        $log->out("No ClientID for uid $uid - skip");
        next;
    }
    my $camps_num = get_one_field_sql(PPC(uid => $uid), "
                        SELECT count(*)
                          FROM users u
                               JOIN users u2 on u2.ClientID = u.ClientID 
                               JOIN campaigns c on c.uid = u2.uid
                         WHERE u.uid = ?
                           AND u.ClientID > 0
                           AND c.statusEmpty = 'No'
                        ", $uid);
    if ($camps_num > 0) {
        $log->out("Campaigns exists for uid=$uid, login=$login - skip");
        next;
    }
    $log->out("Let's ban uid=$uid, login=$login, ClientID=$ClientID");
    API::ClientOptions::add($ClientID, {'api_enabled' => 'No'});
}

$log->out('FINISH');

